import { PROTO } from '../../constants';
import { DeviceAuthenticityConfig } from '../../data/deviceAuthenticityConfigTypes';
import { AuthenticateDeviceResult } from '../../types/api/authenticateDevice';
interface AuthenticityProofData extends PROTO.AuthenticityProof {
    challenge: Buffer;
    config: DeviceAuthenticityConfig;
    allowDebugKeys?: boolean;
    deviceModel: keyof typeof PROTO.DeviceModelInternal;
}
export declare const getRandomChallenge: () => Buffer<ArrayBufferLike>;
export declare const verifyAuthenticityProof: ({ certificates, signature, challenge, config, allowDebugKeys, deviceModel, }: AuthenticityProofData) => Promise<AuthenticateDeviceResult>;
export {};
//# sourceMappingURL=verifyAuthenticityProof.d.ts.map