"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.stripFwHeaders = exports.shouldStripFwHeaders = void 0;
const utils_1 = require("@trezor/utils");
const shouldStripFwHeaders = (features) => {
    if (features.major_version === 2)
        return false;
    return utils_1.versionUtils.isNewerOrEqual([features.major_version, features.minor_version, features.patch_version], [1, 8, 0]);
};
exports.shouldStripFwHeaders = shouldStripFwHeaders;
const stripFwHeaders = (fw) => {
    const fwView = new Uint8Array(fw);
    if (String.fromCharCode(...Array.from(fwView.slice(0, 4))) === 'TRZR' &&
        String.fromCharCode(...Array.from(fwView.slice(256, 260))) === 'TRZF') {
        return fw.slice(256);
    }
    return fw;
};
exports.stripFwHeaders = stripFwHeaders;
//# sourceMappingURL=modifyFirmware.js.map