import { Common } from '@ethereumjs/common';
import { MessagesSchema } from '@trezor/protobuf';
import { PROTO } from '../../constants';
import type { TypedCall } from '../../device/DeviceCommands';
import type { EthereumAccessList, EthereumTransaction, EthereumTransactionEIP1559 } from '../../types/api/ethereum';
export declare const getCommonForChain: (chainId: number) => Common;
export declare const serializeEthereumTx: (tx: EthereumTransactionEIP1559 | EthereumTransaction, signature: {
    v: `0x${string}`;
    r: `0x${string}`;
    s: `0x${string}`;
}, isLegacy: boolean) => string;
export declare const ethereumSignTx: (typedCall: TypedCall, address_n: number[], to: string | null, value: string, gas_limit: string, gas_price: string, nonce: string, chain_id: number, chunkify: boolean, data?: string, tx_type?: number, definitions?: MessagesSchema.EthereumDefinitions, payment_req?: PROTO.PaymentRequest) => Promise<{
    v: `0x${string}`;
    r: `0x${string}`;
    s: `0x${string}`;
}>;
export declare const ethereumSignTxEIP1559: (typedCall: TypedCall, address_n: number[], to: string | null, value: string, gas_limit: string, max_gas_fee: string, max_priority_fee: string, nonce: string, chain_id: number, chunkify: boolean, data?: string, access_list?: EthereumAccessList[], definitions?: MessagesSchema.EthereumDefinitions, payment_req?: PROTO.PaymentRequest) => Promise<{
    v: `0x${string}`;
    r: `0x${string}`;
    s: `0x${string}`;
}>;
//# sourceMappingURL=ethereumSignTx.d.ts.map