import { MessagesSchema } from '@trezor/protobuf';
import { AbstractMethod } from '../../../core/AbstractMethod';
import { EthereumNetworkInfo } from '../../../types';
import { EthereumSignTypedData as EthereumSignTypedDataParams, EthereumSignTypedDataTypes, EthereumSignTypedHash as EthereumSignTypedHashParams } from '../../../types/api/ethereum';
type Params = (Omit<EthereumSignTypedDataParams<EthereumSignTypedDataTypes>, 'path'> | Omit<EthereumSignTypedHashParams<EthereumSignTypedDataTypes>, 'path'>) & {
    address_n: number[];
    network?: EthereumNetworkInfo;
    definitions?: MessagesSchema.EthereumDefinitions;
};
declare const Params: import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
    data: import("@trezor/schema-utils").TObject<{
        types: import("@trezor/schema-utils").TObject<{
            EIP712Domain: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                name: import("@trezor/schema-utils").TString;
                type: import("@trezor/schema-utils").TString;
            }>>;
        }>;
        primaryType: import("@trezor/schema-utils").TString;
        domain: import("@trezor/schema-utils").TObject<{
            name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            version: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            chainId: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TNumber, import("@trezor/schema-utils").TBigInt, import("@trezor/schema-utils").TString]>>;
            verifyingContract: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            salt: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer, import("@trezor/schema-utils").TString]>>;
        }>;
        message: import("@trezor/schema-utils").TObject<{}>;
    }>;
    metamask_v4_compat: import("@trezor/schema-utils").TBoolean;
    domain_separator_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
    message_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
}>, import("@trezor/schema-utils").TObject<{
    data: import("@trezor/schema-utils").TObject<{
        types: import("@trezor/schema-utils").TObject<{
            EIP712Domain: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                name: import("@trezor/schema-utils").TString;
                type: import("@trezor/schema-utils").TString;
            }>>;
        }>;
        primaryType: import("@trezor/schema-utils").TString;
        domain: import("@trezor/schema-utils").TObject<{
            name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            version: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            chainId: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TNumber, import("@trezor/schema-utils").TBigInt, import("@trezor/schema-utils").TString]>>;
            verifyingContract: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            salt: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer, import("@trezor/schema-utils").TString]>>;
        }>;
        message: import("@trezor/schema-utils").TObject<{}>;
    }>;
    metamask_v4_compat: import("@trezor/schema-utils").TBoolean;
    domain_separator_hash: import("@trezor/schema-utils").TString;
    message_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>]>, import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        label: import("@trezor/schema-utils").TString;
        name: import("@trezor/schema-utils").TString;
        shortcut: import("@trezor/schema-utils").TString;
        slip44: import("@trezor/schema-utils").TNumber;
        support: import("@trezor/schema-utils").TObject<{
            connect: import("@trezor/schema-utils").TBoolean;
            T1B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
            T2T1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
            T2B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
            T3B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
            T3T1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
            T3W1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
            UNKNOWN: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        }>;
        decimals: import("@trezor/schema-utils").TNumber;
        blockchainLink: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TString;
            url: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
        }>>;
        blockTime: import("@trezor/schema-utils").TNumber;
        minFee: import("@trezor/schema-utils").TNumber;
        maxFee: import("@trezor/schema-utils").TNumber;
        minPriorityFee: import("@trezor/schema-utils").TNumber;
        defaultFees: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            label: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"high">, import("@trezor/schema-utils").TLiteral<"normal">, import("@trezor/schema-utils").TLiteral<"economy">, import("@trezor/schema-utils").TLiteral<"low">, import("@trezor/schema-utils").TLiteral<"custom">]>;
            blocks: import("@trezor/schema-utils").TNumber;
            feePerUnit: import("@trezor/schema-utils").TString;
            feePerTx: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            feeLimit: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            baseFeePerGas: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            maxFeePerGas: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            maxPriorityFeePerGas: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>>;
    }>, import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TLiteral<"ethereum">;
        chainId: import("@trezor/schema-utils").TNumber;
        network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
    }>]>>;
    definitions: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        encoded_network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
        encoded_token: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
    }>>;
}>]>;
export default class EthereumSignTypedData extends AbstractMethod<'ethereumSignTypedData', Params> {
    init(): void;
    initAsync(): Promise<void>;
    get info(): string;
    getButtonRequestData(code: string, name?: string): {
        type: "message";
        coin: string;
        serializedPath: string;
        message: string;
    } | undefined;
    run(): Promise<{
        address: string;
        signature: string;
    }>;
}
export {};
//# sourceMappingURL=ethereumSignTypedData.d.ts.map