import { MessagesSchema } from '@trezor/protobuf';
import type { PROTO } from '../../../constants';
import { AbstractMethod } from '../../../core/AbstractMethod';
import { EthereumNetworkInfo } from '../../../types';
type Params = PROTO.EthereumSignMessage & {
    network?: EthereumNetworkInfo;
    definitions?: MessagesSchema.EthereumDefinitions;
};
export default class EthereumSignMessage extends AbstractMethod<'ethereumSignMessage', Params> {
    init(): void;
    initAsync(): Promise<void>;
    get info(): string;
    getButtonRequestData(code: string, name?: string): {
        type: "message";
        coin: string;
        serializedPath: string;
        message: string;
    } | undefined;
    run(): Promise<{
        address: string;
        signature: string;
    }>;
}
export {};
//# sourceMappingURL=ethereumSignMessage.d.ts.map