import { Transaction as BitcoinJsTransaction, Network } from '@trezor/utxo-lib';
import { PROTO } from '../../constants';
import type { AccountAddresses, AccountTransaction, BitcoinNetworkInfo, CoinInfo } from '../../types';
import type { RefTransaction, TransactionOptions } from '../../types/api/bitcoin';
export declare const requireReferencedTransactions: (inputs: PROTO.TxInputType[], options?: TransactionOptions, coinInfo?: CoinInfo) => boolean;
export declare const getReferencedTransactions: (inputs: PROTO.TxInputType[]) => string[];
export declare const getOrigTransactions: (inputs: PROTO.TxInputType[], outputs: PROTO.TxOutputType[]) => string[];
export declare const parseTransactionHexes: (network?: Network) => (hexes: string[]) => (import("@trezor/utxo-lib/lib/transaction/base").TransactionBase<undefined> | import("@trezor/utxo-lib/lib/transaction/base").TransactionBase<import("@trezor/utxo-lib/lib/transaction/dash").DashSpecific> | import("@trezor/utxo-lib/lib/transaction/base").TransactionBase<import("@trezor/utxo-lib/lib/transaction/zcash").ZcashSpecific>)[];
export declare const transformOrigTransactions: (txs: BitcoinJsTransaction[], coinInfo: BitcoinNetworkInfo, currentInputs: PROTO.TxInputType[], addresses: AccountAddresses) => RefTransaction[];
export declare const transformReferencedTransaction: (tx: BitcoinJsTransaction) => RefTransaction;
export declare const transformReferencedTransactions: (txs: BitcoinJsTransaction[]) => RefTransaction[];
export declare const validateReferencedTransactions: ({ transactions, inputs, outputs, addresses, coinInfo, }: {
    transactions?: (RefTransaction | AccountTransaction)[];
    inputs: PROTO.TxInputType[];
    outputs: PROTO.TxOutputType[];
    addresses?: AccountAddresses;
    coinInfo: BitcoinNetworkInfo;
}) => RefTransaction[] | undefined;
//# sourceMappingURL=refTx.d.ts.map