"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.enhanceSignTx = void 0;
const BlockchainLink_1 = require("../../backend/BlockchainLink");
const enhanceSignTx = (options, coinInfo) => {
    if (coinInfo.shortcut === 'ZEC' || coinInfo.shortcut === 'TAZ') {
        if (typeof options.overwintered !== 'boolean') {
            options.overwintered = true;
        }
        if (typeof options.version !== 'number') {
            options.version = 5;
        }
        if (typeof options.version_group_id !== 'number') {
            options.version_group_id = 0x26a7270a;
        }
        if (typeof options.branch_id !== 'number') {
            const backend = (0, BlockchainLink_1.findBackend)(coinInfo.shortcut);
            if (backend && backend.serverInfo?.consensusBranchId) {
                options.branch_id = backend.serverInfo.consensusBranchId;
            }
            else {
                options.branch_id = 0xc2d6d0b4;
            }
        }
    }
    if (coinInfo.shortcut === 'KMD') {
        if (typeof options.overwintered !== 'boolean') {
            options.overwintered = true;
        }
        if (typeof options.version !== 'number') {
            options.version = 4;
        }
        if (typeof options.version_group_id !== 'number') {
            options.version_group_id = 0x892f2085;
        }
        if (typeof options.branch_id !== 'number') {
            options.branch_id = 0x76b809bb;
        }
    }
    if (coinInfo.shortcut === 'KOTO') {
        if (typeof options.overwintered !== 'boolean') {
            options.overwintered = true;
        }
        if (typeof options.version !== 'number') {
            options.version = 4;
        }
        if (typeof options.version_group_id !== 'number') {
            options.version_group_id = 0x892f2085;
        }
        if (typeof options.branch_id !== 'number') {
            options.branch_id = 0x2bb40e60;
        }
    }
    if (coinInfo.shortcut === 'PPC' || coinInfo.shortcut === 'tPPC') {
        if (typeof options.timestamp !== 'number') {
            options.timestamp = Math.round(new Date().getTime() / 1000);
        }
    }
    return options;
};
exports.enhanceSignTx = enhanceSignTx;
//# sourceMappingURL=enhanceSignTx.js.map