"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const schema_utils_1 = require("@trezor/schema-utils");
const constants_1 = require("../constants");
const AbstractMethod_1 = require("../core/AbstractMethod");
class BackupDevice extends AbstractMethod_1.AbstractMethod {
    init() {
        this.requiredPermissions = ['management'];
        this.skipFinalReload = false;
        this.useDeviceState = false;
        const { payload } = this;
        (0, schema_utils_1.Assert)(constants_1.PROTO.BackupDevice, payload);
        this.params = {
            group_threshold: payload.group_threshold,
            groups: payload.groups,
        };
    }
    get confirmation() {
        return {
            view: 'device-management',
            customConfirmButton: {
                className: 'confirm',
                label: 'Proceed',
            },
            label: 'Do you want to initiate backup procedure?',
        };
    }
    async run() {
        const cmd = this.device.getCommands();
        const response = await cmd.typedCall('BackupDevice', 'Success', this.params);
        return response.message;
    }
}
exports.default = BackupDevice;
//# sourceMappingURL=backupDevice.js.map