"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.discoverAddress = void 0;
const transform_1 = require("./transform");
const discoverAddress = (client) => async ({ address, path }) => {
    const scripthash = (0, transform_1.addressToScripthash)(address, client.getInfo()?.network);
    const history = await client.request('blockchain.scripthash.get_history', scripthash);
    return {
        address,
        scripthash,
        path,
        history,
        empty: !history.length,
    };
};
exports.discoverAddress = discoverAddress;
//# sourceMappingURL=discovery.js.map