"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAddressManager = void 0;
const utils_1 = require("@trezor/utils");
const transform_1 = require("./transform");
const addressesFromAccounts = (array) => array
    .filter(utils_1.isNotUndefined)
    .flatMap(({ change, used, unused }) => change.concat(used, unused).map(({ address }) => address));
const createAddressManager = (getNetwork) => {
    let subscribedAddrs = {};
    let subscribedAccs = {};
    const addAddresses = (addresses) => {
        const toAdd = addresses.filter(utils_1.arrayDistinct).filter(addr => !subscribedAddrs[addr]);
        const network = getNetwork();
        subscribedAddrs = toAdd.reduce((dic, addr) => ({
            ...dic,
            [addr]: (0, transform_1.addressToScripthash)(addr, network),
        }), subscribedAddrs);
        return toAdd.map(addr => subscribedAddrs[addr]);
    };
    const removeAddresses = (addresses) => {
        const [toRemove, toPreserve] = addresses
            ? (0, utils_1.objectPartition)(subscribedAddrs, addresses)
            : [subscribedAddrs, {}];
        subscribedAddrs = toPreserve;
        return Object.values(toRemove);
    };
    const addAccounts = (accounts) => {
        const toAdd = accounts.filter(acc => !subscribedAccs[acc.descriptor]);
        subscribedAccs = toAdd.reduce((dic, acc) => ({
            ...dic,
            [acc.descriptor]: acc.addresses || { change: [], used: [], unused: [] },
        }), subscribedAccs);
        const addresses = addressesFromAccounts(toAdd.map(acc => acc.addresses));
        return addAddresses(addresses);
    };
    const removeAccounts = (accounts) => {
        const [toRemove, toPreserve] = accounts
            ? (0, utils_1.objectPartition)(subscribedAccs, accounts.map(({ descriptor }) => descriptor))
            : [subscribedAccs, {}];
        subscribedAccs = toPreserve;
        const addresses = addressesFromAccounts(Object.values(toRemove));
        return removeAddresses(addresses);
    };
    const getCount = () => Object.keys(subscribedAddrs).length;
    const getInfo = (scripthash) => {
        const [address, _sh] = Object.entries(subscribedAddrs).find(([_addr, sh]) => sh === scripthash) || [];
        if (!address)
            return { descriptor: scripthash };
        const [account, addresses] = Object.entries(subscribedAccs).find(([_acc, { change, unused, used }]) => !!change.concat(used, unused).find(ad => ad.address === address)) || [];
        return {
            descriptor: account || address,
            addresses,
        };
    };
    return {
        addAddresses,
        removeAddresses,
        addAccounts,
        removeAccounts,
        getCount,
        getInfo,
    };
};
exports.createAddressManager = createAddressManager;
//# sourceMappingURL=addressManager.js.map