"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TlsSocket = void 0;
const tls_1 = require("tls");
const base_1 = require("./base");
class TlsSocket extends base_1.SocketBase {
    openSocket(listener) {
        const socket = new tls_1.TLSSocket(null);
        this.configureSocket(socket);
        this.bindSocket(socket, listener);
        return new Promise((resolve, reject) => {
            const errorHandler = (err) => reject(err);
            socket.on('error', errorHandler);
            socket.connect(this.port, this.host, () => {
                socket.removeListener('error', errorHandler);
                resolve(socket);
            });
        });
    }
}
exports.TlsSocket = TlsSocket;
//# sourceMappingURL=tls.js.map