"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SocketBase = void 0;
const TIMEOUT = 10000;
const KEEP_ALIVE = true;
class SocketBase {
    socket;
    host;
    port;
    timeout;
    keepAlive;
    constructor({ host, port, timeout, keepAlive }) {
        this.host = host;
        this.port = port;
        this.timeout = timeout !== undefined ? timeout : TIMEOUT;
        this.keepAlive = keepAlive !== undefined ? keepAlive : KEEP_ALIVE;
    }
    async connect(listener) {
        this.socket = await this.openSocket(listener);
    }
    close() {
        this.socket?.end();
        this.socket?.destroy();
    }
    send(data) {
        return this.socket?.write(data);
    }
    configureSocket(socket) {
        socket.setTimeout(this.timeout);
        socket.setEncoding('utf8');
        socket.setKeepAlive(this.keepAlive);
        socket.setNoDelay(true);
    }
    bindSocket(socket, listener) {
        socket.on('connect', () => {
            socket.setTimeout(0);
            listener.onConnect();
        });
        socket.on('close', e => {
            listener.onClose(e);
        });
        socket.on('timeout', () => {
            const e = new Error('ETIMEDOUT');
            e.errorno = 'ETIMEDOUT';
            e.code = 'ETIMEDOUT';
            e.connect = false;
            socket.emit('error', e);
        });
        socket.on('data', chunk => {
            socket.setTimeout(0);
            listener.onReceive(chunk);
        });
        socket.on('end', (e) => {
            socket.setTimeout(0);
            listener.onEnd(e);
        });
        socket.on('error', e => {
            listener.onError(e);
        });
    }
}
exports.SocketBase = SocketBase;
//# sourceMappingURL=base.js.map