"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BlockfrostAPI = void 0;
const env_utils_1 = require("@trezor/env-utils");
const baseWebsocket_1 = require("../baseWebsocket");
class BlockfrostAPI extends baseWebsocket_1.BaseWebsocket {
    createWebsocket() {
        const { url } = this.options;
        return this.initWebsocket({
            url,
            agent: this.options.agent,
            headers: {
                'User-Agent': `Trezor Suite ${(0, env_utils_1.getSuiteVersion)()}`,
                ...this.options.headers,
            },
        });
    }
    ping() {
        return this.getBlockHash(1);
    }
    send = (command, params = {}) => this.sendMessage({ command, params });
    getServerInfo() {
        return this.send('GET_SERVER_INFO');
    }
    getBlockHash(number) {
        return this.send('GET_BLOCK', { hashOrNumber: number });
    }
    estimateFee(payload) {
        return this.send('ESTIMATE_FEE', payload);
    }
    getAccountInfo(payload) {
        return this.send('GET_ACCOUNT_INFO', payload);
    }
    getAccountUtxo(descriptor) {
        return this.send('GET_ACCOUNT_UTXO', { descriptor });
    }
    getAccountBalanceHistory(payload) {
        return this.send('GET_BALANCE_HISTORY', payload);
    }
    getTransaction(txId) {
        return this.send('GET_TRANSACTION', { txId });
    }
    pushTransaction(txData) {
        return this.send('PUSH_TRANSACTION', { txData });
    }
    subscribeBlock() {
        this.removeSubscription('block');
        this.addSubscription('block', result => this.emit('block', result));
        return this.send('SUBSCRIBE_BLOCK');
    }
    subscribeAddresses(addresses) {
        this.removeSubscription('notification');
        this.addSubscription('notification', result => this.emit('notification', result));
        return this.send('SUBSCRIBE_ADDRESS', { addresses });
    }
    unsubscribeBlock() {
        const index = this.removeSubscription('block');
        return index >= 0 ? this.send('UNSUBSCRIBE_BLOCK') : { subscribed: false };
    }
    unsubscribeAddresses() {
        const index = this.removeSubscription('notification');
        return index >= 0 ? this.send('UNSUBSCRIBE_ADDRESS') : { subscribed: false };
    }
}
exports.BlockfrostAPI = BlockfrostAPI;
//# sourceMappingURL=websocket.js.map