"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseWebsocket = void 0;
const errors_1 = require("@trezor/blockchain-link-types/lib/constants/errors");
const websocket_client_1 = require("@trezor/websocket-client");
class BaseWebsocket extends websocket_client_1.WebsocketClient {
    subscriptions = [];
    async onPing() {
        if (this.subscriptions.length > 0 || this.options.keepAlive) {
            await this.ping().catch(error => {
                throw new errors_1.CustomError('websocket_runtime_error', error.message);
            });
        }
        else {
            this.disconnect();
        }
    }
    onMessage(message) {
        super.onMessage(message, ({ id, data }) => {
            if (data.error) {
                throw new errors_1.CustomError('websocket_error_message', data.error.message);
            }
            const messageSettled = this.messages.resolve(Number(id), data);
            if (!messageSettled) {
                const subs = this.subscriptions.find(s => s.id === id);
                if (subs) {
                    subs.callback(data);
                }
            }
        });
    }
    sendMessage(message) {
        return super.sendMessage(message).catch(error => {
            throw new errors_1.CustomError(error.message);
        });
    }
    addSubscription(type, callback) {
        const id = this.messages.nextId().toString();
        this.subscriptions.push({ id, type, callback });
    }
    removeSubscription(type) {
        const index = this.subscriptions.findIndex(s => s.type === type);
        if (index >= 0) {
            this.subscriptions.splice(index, 1);
        }
        return index;
    }
}
exports.BaseWebsocket = BaseWebsocket;
//# sourceMappingURL=baseWebsocket.js.map