import type { AccountBalanceHistory } from './common';
import type { AccountBalanceHistoryParams, AccountInfoParams, EstimateFeeParams } from './params';
type TxContentUtxo = {
    hash: string;
    inputs: {
        address: string;
        amount: AssetBalance[];
        tx_hash: string;
        output_index: number;
        data_hash: string | null;
        collateral: boolean;
    }[];
    outputs: {
        address: string;
        amount: AssetBalance[];
        output_index: number;
        data_hash?: string | null;
    }[];
};
type AddressUtxoContent = {
    tx_hash: string;
    tx_index: number;
    output_index: number;
    amount: AssetBalance[];
    block: string;
    data_hash: string | null;
}[];
type TxContent = {
    hash: string;
    block: string;
    block_height: number;
    block_time: number;
    slot: number;
    index: number;
    output_amount: AssetBalance[];
    fees: string;
    deposit: string;
    size: number;
    invalid_before: string | null;
    invalid_hereafter: string | null;
    utxo_count: number;
    withdrawal_count: number;
    mir_cert_count: number;
    delegation_count: number;
    stake_cert_count: number;
    pool_update_count: number;
    pool_retire_count: number;
    asset_mint_or_burn_count: number;
    redeemer_count: number;
    valid_contract: boolean;
};
export type BlockContent = {
    time: number;
    height: number | null;
    hash: string;
    slot: number | null;
    epoch: number | null;
    epoch_slot: number | null;
    slot_leader: string;
    size: number;
    tx_count: number;
    output: string | null;
    fees: string | null;
    block_vrf: string | null;
    previous_block: string | null;
    next_block: string | null;
    confirmations: number;
};
export interface Subscribe {
    subscribed: boolean;
}
export type Fee = {
    lovelacePerByte: number;
};
export interface Address {
    address: string;
    path: string;
    transfers: number;
    balance: string;
    sent: string;
    received: string;
}
export interface AccountAddresses {
    change: Address[];
    used: Address[];
    unused: Address[];
}
export interface BlockfrostTransaction {
    address: string;
    txHash: string;
    txUtxos: TxContentUtxo;
    txData: TxContent;
}
export interface BlockfrostAccountInfo {
    balance: string;
    addresses: AccountAddresses;
    empty: boolean;
    availableBalance: string;
    descriptor: string;
    tokens?: AssetBalance[];
    history: {
        total: number;
        tokens?: number;
        unconfirmed: number;
        transactions?: BlockfrostTransaction[];
    };
    page: {
        size: number;
        total: number;
        index: number;
    };
    misc: {
        staking: {
            address: string;
            isActive: boolean;
            rewards: string;
            poolId: string | null;
            drep: {
                drep_id: string;
                hex: string;
                amount: string;
                active: boolean;
                active_epoch: number | null;
                has_script: boolean;
            } | null;
        };
    };
}
export interface ParseAssetResult {
    policyId: string;
    assetName: string;
}
export interface AddressNotification {
    address: string;
    tx: any;
}
export interface ServerInfo {
    name: string;
    shortcut: string;
    testnet: boolean;
    version: string;
    decimals: number;
    blockHeight: number;
    blockHash: string;
}
export interface AccountUtxoParams {
    descriptor: string;
}
export type AccountUtxo = {
    txid: string;
    vout: number;
    value: string;
    height: number;
    address: string;
    path: string;
}[];
export interface UtxosData extends AddressUtxoContent {
    blockInformation: BlockContent;
}
export interface AssetBalance {
    unit: string;
    quantity: string;
    decimals: number;
    ticker: string | null;
    name: string | null;
    fingerprint?: string;
}
export type BlockfrostToken = {
    type: 'BLOCKFROST';
    standard: 'BLOCKFROST';
    name: string;
    contract: string;
    symbol: string;
    balance: string;
    decimals: number;
};
export interface Output {
    address: string;
    amount: AssetBalance[];
}
export interface Input {
    address: string;
    amount: AssetBalance[];
}
export interface BlockfrostUtxoData {
    tx_hash: string;
    tx_index: number;
    output_index: number;
    amount: {
        unit: string;
        quantity: string;
    }[];
    block: string;
}
export interface BlockfrostUtxos {
    address: string;
    path: string;
    utxoData: BlockfrostUtxoData;
    blockInfo: BlockContent;
}
declare function FSend(method: 'GET_SERVER_INFO'): Promise<ServerInfo>;
declare function FSend(method: 'GET_BLOCK', params: {
    hashOrNumber: number | string;
}): Promise<BlockContent>;
declare function FSend(method: 'GET_ACCOUNT_INFO', params: AccountInfoParams): Promise<BlockfrostAccountInfo>;
declare function FSend(method: 'GET_ACCOUNT_UTXO', params: AccountUtxoParams): Promise<BlockfrostUtxos[]>;
declare function FSend(method: 'GET_TRANSACTION', params: {
    txId: string;
}): Promise<TxContent>;
declare function FSend(method: 'PUSH_TRANSACTION', params: {
    txData: string;
}): Promise<string>;
declare function FSend(method: 'SUBSCRIBE_BLOCK'): Promise<Subscribe>;
declare function FSend(method: 'UNSUBSCRIBE_BLOCK'): Promise<Subscribe>;
declare function FSend(method: 'SUBSCRIBE_ADDRESS', params: {
    addresses: string[];
}): Promise<Subscribe>;
declare function FSend(method: 'UNSUBSCRIBE_ADDRESS'): Promise<Subscribe>;
declare function FSend(method: 'GET_BALANCE_HISTORY', params: AccountBalanceHistoryParams): Promise<AccountBalanceHistory[]>;
declare function FSend(method: 'ESTIMATE_FEE', params: EstimateFeeParams): Promise<Fee>;
export type Send = typeof FSend;
export {};
//# sourceMappingURL=blockfrost.d.ts.map