import { Brand, EncodedString } from '@solana/nominal-types';
import { Transaction } from './transaction';
/** Represents the wire format of a transaction as a base64-encoded string. */
export type Base64EncodedWireTransaction = Brand<EncodedString<string, 'base64'>, 'Base64EncodedWireTransaction'>;
/**
 * Given a signed transaction, this method returns the transaction as a string that conforms to the
 * {@link Base64EncodedWireTransaction} type.
 *
 * @example
 * ```ts
 * import { getBase64EncodedWireTransaction, signTransaction } from '@solana/transactions';
 *
 * const serializedTransaction = getBase64EncodedWireTransaction(signedTransaction);
 * const signature = await rpc.sendTransaction(serializedTransaction, { encoding: 'base64' }).send();
 * ```
 */
export declare function getBase64EncodedWireTransaction(transaction: Transaction): Base64EncodedWireTransaction;
//# sourceMappingURL=wire-transaction.d.ts.map