import { fetchEncodedAccount, fetchJsonParsedAccount, assertAccountExists, decodeAccount } from '@solana/accounts';
import { getStructEncoder, getU64Encoder, getI64Encoder, getStructDecoder, getU64Decoder, getI64Decoder, combineCodec, getU128Encoder, getBooleanEncoder, getU128Decoder, getBooleanDecoder, getArrayEncoder, getArrayDecoder, getF64Encoder, getU8Encoder, getF64Decoder, getU8Decoder, createEncoder, createDecoder, getArrayCodec, getU64Codec } from '@solana/codecs';
import { getBlockhashEncoder, getDefaultLamportsEncoder, getBlockhashDecoder, getDefaultLamportsDecoder } from '@solana/rpc-types';
import { SolanaError, SOLANA_ERROR__CODECS__INVALID_BYTE_LENGTH, SOLANA_ERROR__CODECS__ENUM_DISCRIMINATOR_OUT_OF_RANGE, SOLANA_ERROR__CODECS__INVALID_NUMBER_OF_ITEMS } from '@solana/errors';

// src/clock.ts
var SYSVAR_CLOCK_ADDRESS = "SysvarC1ock11111111111111111111111111111111";
var SYSVAR_EPOCH_REWARDS_ADDRESS = "SysvarEpochRewards1111111111111111111111111";
var SYSVAR_EPOCH_SCHEDULE_ADDRESS = "SysvarEpochSchedu1e111111111111111111111111";
var SYSVAR_INSTRUCTIONS_ADDRESS = "Sysvar1nstructions1111111111111111111111111";
var SYSVAR_LAST_RESTART_SLOT_ADDRESS = "SysvarLastRestartS1ot1111111111111111111111";
var SYSVAR_RECENT_BLOCKHASHES_ADDRESS = "SysvarRecentB1ockHashes11111111111111111111";
var SYSVAR_RENT_ADDRESS = "SysvarRent111111111111111111111111111111111";
var SYSVAR_SLOT_HASHES_ADDRESS = "SysvarS1otHashes111111111111111111111111111";
var SYSVAR_SLOT_HISTORY_ADDRESS = "SysvarS1otHistory11111111111111111111111111";
var SYSVAR_STAKE_HISTORY_ADDRESS = "SysvarStakeHistory1111111111111111111111111";
async function fetchEncodedSysvarAccount(rpc, address, config) {
  return await fetchEncodedAccount(rpc, address, config);
}
async function fetchJsonParsedSysvarAccount(rpc, address, config) {
  return await fetchJsonParsedAccount(rpc, address, config);
}

// src/clock.ts
function getSysvarClockEncoder() {
  return getStructEncoder([
    ["slot", getU64Encoder()],
    ["epochStartTimestamp", getI64Encoder()],
    ["epoch", getU64Encoder()],
    ["leaderScheduleEpoch", getU64Encoder()],
    ["unixTimestamp", getI64Encoder()]
  ]);
}
function getSysvarClockDecoder() {
  return getStructDecoder([
    ["slot", getU64Decoder()],
    ["epochStartTimestamp", getI64Decoder()],
    ["epoch", getU64Decoder()],
    ["leaderScheduleEpoch", getU64Decoder()],
    ["unixTimestamp", getI64Decoder()]
  ]);
}
function getSysvarClockCodec() {
  return combineCodec(getSysvarClockEncoder(), getSysvarClockDecoder());
}
async function fetchSysvarClock(rpc, config) {
  const account = await fetchEncodedSysvarAccount(rpc, SYSVAR_CLOCK_ADDRESS, config);
  assertAccountExists(account);
  const decoded = decodeAccount(account, getSysvarClockDecoder());
  return decoded.data;
}
function getSysvarEpochRewardsEncoder() {
  return getStructEncoder([
    ["distributionStartingBlockHeight", getU64Encoder()],
    ["numPartitions", getU64Encoder()],
    ["parentBlockhash", getBlockhashEncoder()],
    ["totalPoints", getU128Encoder()],
    ["totalRewards", getDefaultLamportsEncoder()],
    ["distributedRewards", getDefaultLamportsEncoder()],
    ["active", getBooleanEncoder()]
  ]);
}
function getSysvarEpochRewardsDecoder() {
  return getStructDecoder([
    ["distributionStartingBlockHeight", getU64Decoder()],
    ["numPartitions", getU64Decoder()],
    ["parentBlockhash", getBlockhashDecoder()],
    ["totalPoints", getU128Decoder()],
    ["totalRewards", getDefaultLamportsDecoder()],
    ["distributedRewards", getDefaultLamportsDecoder()],
    ["active", getBooleanDecoder()]
  ]);
}
function getSysvarEpochRewardsCodec() {
  return combineCodec(getSysvarEpochRewardsEncoder(), getSysvarEpochRewardsDecoder());
}
async function fetchSysvarEpochRewards(rpc, config) {
  const account = await fetchEncodedSysvarAccount(rpc, SYSVAR_EPOCH_REWARDS_ADDRESS, config);
  assertAccountExists(account);
  const decoded = decodeAccount(account, getSysvarEpochRewardsDecoder());
  return decoded.data;
}
function getSysvarEpochScheduleEncoder() {
  return getStructEncoder([
    ["slotsPerEpoch", getU64Encoder()],
    ["leaderScheduleSlotOffset", getU64Encoder()],
    ["warmup", getBooleanEncoder()],
    ["firstNormalEpoch", getU64Encoder()],
    ["firstNormalSlot", getU64Encoder()]
  ]);
}
function getSysvarEpochScheduleDecoder() {
  return getStructDecoder([
    ["slotsPerEpoch", getU64Decoder()],
    ["leaderScheduleSlotOffset", getU64Decoder()],
    ["warmup", getBooleanDecoder()],
    ["firstNormalEpoch", getU64Decoder()],
    ["firstNormalSlot", getU64Decoder()]
  ]);
}
function getSysvarEpochScheduleCodec() {
  return combineCodec(getSysvarEpochScheduleEncoder(), getSysvarEpochScheduleDecoder());
}
async function fetchSysvarEpochSchedule(rpc, config) {
  const account = await fetchEncodedSysvarAccount(rpc, SYSVAR_EPOCH_SCHEDULE_ADDRESS, config);
  assertAccountExists(account);
  const decoded = decodeAccount(account, getSysvarEpochScheduleDecoder());
  return decoded.data;
}
function getSysvarLastRestartSlotEncoder() {
  return getStructEncoder([["lastRestartSlot", getU64Encoder()]]);
}
function getSysvarLastRestartSlotDecoder() {
  return getStructDecoder([["lastRestartSlot", getU64Decoder()]]);
}
function getSysvarLastRestartSlotCodec() {
  return combineCodec(getSysvarLastRestartSlotEncoder(), getSysvarLastRestartSlotDecoder());
}
async function fetchSysvarLastRestartSlot(rpc, config) {
  const account = await fetchEncodedSysvarAccount(rpc, SYSVAR_LAST_RESTART_SLOT_ADDRESS, config);
  assertAccountExists(account);
  const decoded = decodeAccount(account, getSysvarLastRestartSlotDecoder());
  return decoded.data;
}
function getSysvarRecentBlockhashesEncoder() {
  return getArrayEncoder(
    getStructEncoder([
      ["blockhash", getBlockhashEncoder()],
      ["feeCalculator", getStructEncoder([["lamportsPerSignature", getDefaultLamportsEncoder()]])]
    ])
  );
}
function getSysvarRecentBlockhashesDecoder() {
  return getArrayDecoder(
    getStructDecoder([
      ["blockhash", getBlockhashDecoder()],
      ["feeCalculator", getStructDecoder([["lamportsPerSignature", getDefaultLamportsDecoder()]])]
    ])
  );
}
function getSysvarRecentBlockhashesCodec() {
  return combineCodec(getSysvarRecentBlockhashesEncoder(), getSysvarRecentBlockhashesDecoder());
}
async function fetchSysvarRecentBlockhashes(rpc, config) {
  const account = await fetchEncodedSysvarAccount(rpc, SYSVAR_RECENT_BLOCKHASHES_ADDRESS, config);
  assertAccountExists(account);
  const decoded = decodeAccount(account, getSysvarRecentBlockhashesDecoder());
  return decoded.data;
}
function getSysvarRentEncoder() {
  return getStructEncoder([
    ["lamportsPerByteYear", getDefaultLamportsEncoder()],
    ["exemptionThreshold", getF64Encoder()],
    ["burnPercent", getU8Encoder()]
  ]);
}
function getSysvarRentDecoder() {
  return getStructDecoder([
    ["lamportsPerByteYear", getDefaultLamportsDecoder()],
    ["exemptionThreshold", getF64Decoder()],
    ["burnPercent", getU8Decoder()]
  ]);
}
function getSysvarRentCodec() {
  return combineCodec(getSysvarRentEncoder(), getSysvarRentDecoder());
}
async function fetchSysvarRent(rpc, config) {
  const account = await fetchEncodedSysvarAccount(rpc, SYSVAR_RENT_ADDRESS, config);
  assertAccountExists(account);
  const decoded = decodeAccount(account, getSysvarRentDecoder());
  return decoded.data;
}
function getSysvarSlotHashesEncoder() {
  return getArrayEncoder(
    getStructEncoder([
      ["slot", getU64Encoder()],
      ["hash", getBlockhashEncoder()]
    ])
  );
}
function getSysvarSlotHashesDecoder() {
  return getArrayDecoder(
    getStructDecoder([
      ["slot", getU64Decoder()],
      ["hash", getBlockhashDecoder()]
    ])
  );
}
function getSysvarSlotHashesCodec() {
  return combineCodec(getSysvarSlotHashesEncoder(), getSysvarSlotHashesDecoder());
}
async function fetchSysvarSlotHashes(rpc, config) {
  const account = await fetchEncodedSysvarAccount(rpc, SYSVAR_SLOT_HASHES_ADDRESS, config);
  assertAccountExists(account);
  const decoded = decodeAccount(account, getSysvarSlotHashesDecoder());
  return decoded.data;
}
var BITVEC_DISCRIMINATOR = 1;
var BITVEC_NUM_BITS = 1024 * 1024;
var BITVEC_LENGTH = BITVEC_NUM_BITS / 64;
var SLOT_HISTORY_ACCOUNT_DATA_STATIC_SIZE = 1 + // Discriminator
8 + // bitvector length (u64)
BITVEC_LENGTH * 8 + 8 + // Number of bits (u64)
8;
var memoizedU64Encoder;
var memoizedU64Decoder;
var memoizedU64ArrayEncoder;
var memoizedU64ArrayDecoder;
function getMemoizedU64Encoder() {
  if (!memoizedU64Encoder) memoizedU64Encoder = getU64Encoder();
  return memoizedU64Encoder;
}
function getMemoizedU64Decoder() {
  if (!memoizedU64Decoder) memoizedU64Decoder = getU64Decoder();
  return memoizedU64Decoder;
}
function getMemoizedU64ArrayEncoder() {
  if (!memoizedU64ArrayEncoder) memoizedU64ArrayEncoder = getArrayCodec(getU64Codec(), { size: BITVEC_LENGTH });
  return memoizedU64ArrayEncoder;
}
function getMemoizedU64ArrayDecoder() {
  if (!memoizedU64ArrayDecoder) memoizedU64ArrayDecoder = getArrayCodec(getU64Codec(), { size: BITVEC_LENGTH });
  return memoizedU64ArrayDecoder;
}
function getSysvarSlotHistoryEncoder() {
  return createEncoder({
    fixedSize: SLOT_HISTORY_ACCOUNT_DATA_STATIC_SIZE,
    write: (value, bytes, offset) => {
      bytes.set([BITVEC_DISCRIMINATOR], offset);
      offset += 1;
      getMemoizedU64Encoder().write(BigInt(BITVEC_LENGTH), bytes, offset);
      offset += 8;
      getMemoizedU64ArrayEncoder().write(value.bits, bytes, offset);
      offset += BITVEC_LENGTH * 8;
      getMemoizedU64Encoder().write(BigInt(BITVEC_NUM_BITS), bytes, offset);
      offset += 8;
      getMemoizedU64Encoder().write(value.nextSlot, bytes, offset);
      offset += 8;
      return offset;
    }
  });
}
function getSysvarSlotHistoryDecoder() {
  return createDecoder({
    fixedSize: SLOT_HISTORY_ACCOUNT_DATA_STATIC_SIZE,
    read: (bytes, offset) => {
      if (bytes.length != SLOT_HISTORY_ACCOUNT_DATA_STATIC_SIZE) {
        throw new SolanaError(SOLANA_ERROR__CODECS__INVALID_BYTE_LENGTH, {
          actual: bytes.length,
          expected: SLOT_HISTORY_ACCOUNT_DATA_STATIC_SIZE
        });
      }
      const discriminator = bytes[offset];
      offset += 1;
      if (discriminator !== BITVEC_DISCRIMINATOR) {
        throw new SolanaError(SOLANA_ERROR__CODECS__ENUM_DISCRIMINATOR_OUT_OF_RANGE, {
          actual: discriminator,
          expected: BITVEC_DISCRIMINATOR
        });
      }
      const bitVecLength = getMemoizedU64Decoder().read(bytes, offset)[0];
      offset += 8;
      if (bitVecLength !== BigInt(BITVEC_LENGTH)) {
        throw new SolanaError(SOLANA_ERROR__CODECS__INVALID_NUMBER_OF_ITEMS, {
          actual: bitVecLength,
          codecDescription: "SysvarSlotHistoryCodec",
          expected: BITVEC_LENGTH
        });
      }
      const bits = getMemoizedU64ArrayDecoder().read(bytes, offset)[0];
      offset += BITVEC_LENGTH * 8;
      const numBits = getMemoizedU64Decoder().read(bytes, offset)[0];
      offset += 8;
      if (numBits !== BigInt(BITVEC_NUM_BITS)) {
        throw new SolanaError(SOLANA_ERROR__CODECS__INVALID_NUMBER_OF_ITEMS, {
          actual: numBits,
          codecDescription: "SysvarSlotHistoryCodec",
          expected: BITVEC_NUM_BITS
        });
      }
      const nextSlot = getMemoizedU64Decoder().read(bytes, offset)[0];
      offset += 8;
      return [
        {
          bits,
          nextSlot
        },
        offset
      ];
    }
  });
}
function getSysvarSlotHistoryCodec() {
  return combineCodec(getSysvarSlotHistoryEncoder(), getSysvarSlotHistoryDecoder());
}
async function fetchSysvarSlotHistory(rpc, config) {
  const account = await fetchEncodedSysvarAccount(rpc, SYSVAR_SLOT_HISTORY_ADDRESS, config);
  assertAccountExists(account);
  const decoded = decodeAccount(account, getSysvarSlotHistoryDecoder());
  return decoded.data;
}
function getSysvarStakeHistoryEncoder() {
  return getArrayEncoder(
    getStructEncoder([
      ["epoch", getU64Encoder()],
      [
        "stakeHistory",
        getStructEncoder([
          ["effective", getDefaultLamportsEncoder()],
          ["activating", getDefaultLamportsEncoder()],
          ["deactivating", getDefaultLamportsEncoder()]
        ])
      ]
    ]),
    { size: getU64Encoder() }
  );
}
function getSysvarStakeHistoryDecoder() {
  return getArrayDecoder(
    getStructDecoder([
      ["epoch", getU64Decoder()],
      [
        "stakeHistory",
        getStructDecoder([
          ["effective", getDefaultLamportsDecoder()],
          ["activating", getDefaultLamportsDecoder()],
          ["deactivating", getDefaultLamportsDecoder()]
        ])
      ]
    ]),
    { size: getU64Decoder() }
  );
}
function getSysvarStakeHistoryCodec() {
  return combineCodec(getSysvarStakeHistoryEncoder(), getSysvarStakeHistoryDecoder());
}
async function fetchSysvarStakeHistory(rpc, config) {
  const account = await fetchEncodedSysvarAccount(rpc, SYSVAR_STAKE_HISTORY_ADDRESS, config);
  assertAccountExists(account);
  const decoded = decodeAccount(account, getSysvarStakeHistoryDecoder());
  return decoded.data;
}

export { SYSVAR_CLOCK_ADDRESS, SYSVAR_EPOCH_REWARDS_ADDRESS, SYSVAR_EPOCH_SCHEDULE_ADDRESS, SYSVAR_INSTRUCTIONS_ADDRESS, SYSVAR_LAST_RESTART_SLOT_ADDRESS, SYSVAR_RECENT_BLOCKHASHES_ADDRESS, SYSVAR_RENT_ADDRESS, SYSVAR_SLOT_HASHES_ADDRESS, SYSVAR_SLOT_HISTORY_ADDRESS, SYSVAR_STAKE_HISTORY_ADDRESS, fetchEncodedSysvarAccount, fetchJsonParsedSysvarAccount, fetchSysvarClock, fetchSysvarEpochRewards, fetchSysvarEpochSchedule, fetchSysvarLastRestartSlot, fetchSysvarRecentBlockhashes, fetchSysvarRent, fetchSysvarSlotHashes, fetchSysvarSlotHistory, fetchSysvarStakeHistory, getSysvarClockCodec, getSysvarClockDecoder, getSysvarClockEncoder, getSysvarEpochRewardsCodec, getSysvarEpochRewardsDecoder, getSysvarEpochRewardsEncoder, getSysvarEpochScheduleCodec, getSysvarEpochScheduleDecoder, getSysvarEpochScheduleEncoder, getSysvarLastRestartSlotCodec, getSysvarLastRestartSlotDecoder, getSysvarLastRestartSlotEncoder, getSysvarRecentBlockhashesCodec, getSysvarRecentBlockhashesDecoder, getSysvarRecentBlockhashesEncoder, getSysvarRentCodec, getSysvarRentDecoder, getSysvarRentEncoder, getSysvarSlotHashesCodec, getSysvarSlotHashesDecoder, getSysvarSlotHashesEncoder, getSysvarSlotHistoryCodec, getSysvarSlotHistoryDecoder, getSysvarSlotHistoryEncoder, getSysvarStakeHistoryCodec, getSysvarStakeHistoryDecoder, getSysvarStakeHistoryEncoder };
//# sourceMappingURL=index.native.mjs.map
//# sourceMappingURL=index.native.mjs.map