/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type ReadonlyAccount, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount } from '@solana/kit';
import { TOKEN_PROGRAM_ADDRESS } from '../programs';
export declare const APPROVE_DISCRIMINATOR = 4;
export declare function getApproveDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type ApproveInstruction<TProgram extends string = typeof TOKEN_PROGRAM_ADDRESS, TAccountSource extends string | IAccountMeta<string> = string, TAccountDelegate extends string | IAccountMeta<string> = string, TAccountOwner extends string | IAccountMeta<string> = string, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountSource extends string ? WritableAccount<TAccountSource> : TAccountSource,
    TAccountDelegate extends string ? ReadonlyAccount<TAccountDelegate> : TAccountDelegate,
    TAccountOwner extends string ? ReadonlyAccount<TAccountOwner> : TAccountOwner,
    ...TRemainingAccounts
]>;
export type ApproveInstructionData = {
    discriminator: number;
    /** The amount of tokens the delegate is approved for. */
    amount: bigint;
};
export type ApproveInstructionDataArgs = {
    /** The amount of tokens the delegate is approved for. */
    amount: number | bigint;
};
export declare function getApproveInstructionDataEncoder(): Encoder<ApproveInstructionDataArgs>;
export declare function getApproveInstructionDataDecoder(): Decoder<ApproveInstructionData>;
export declare function getApproveInstructionDataCodec(): Codec<ApproveInstructionDataArgs, ApproveInstructionData>;
export type ApproveInput<TAccountSource extends string = string, TAccountDelegate extends string = string, TAccountOwner extends string = string> = {
    /** The source account. */
    source: Address<TAccountSource>;
    /** The delegate. */
    delegate: Address<TAccountDelegate>;
    /** The source account owner or its multisignature account. */
    owner: Address<TAccountOwner> | TransactionSigner<TAccountOwner>;
    amount: ApproveInstructionDataArgs['amount'];
    multiSigners?: Array<TransactionSigner>;
};
export declare function getApproveInstruction<TAccountSource extends string, TAccountDelegate extends string, TAccountOwner extends string, TProgramAddress extends Address = typeof TOKEN_PROGRAM_ADDRESS>(input: ApproveInput<TAccountSource, TAccountDelegate, TAccountOwner>, config?: {
    programAddress?: TProgramAddress;
}): ApproveInstruction<TProgramAddress, TAccountSource, TAccountDelegate, (typeof input)['owner'] extends TransactionSigner<TAccountOwner> ? ReadonlySignerAccount<TAccountOwner> & IAccountSignerMeta<TAccountOwner> : TAccountOwner>;
export type ParsedApproveInstruction<TProgram extends string = typeof TOKEN_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** The source account. */
        source: TAccountMetas[0];
        /** The delegate. */
        delegate: TAccountMetas[1];
        /** The source account owner or its multisignature account. */
        owner: TAccountMetas[2];
    };
    data: ApproveInstructionData;
};
export declare function parseApproveInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedApproveInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=approve.d.ts.map