/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type Option, type OptionOrNullable, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount } from '@solana/kit';
import { TOKEN_2022_PROGRAM_ADDRESS } from '../programs';
export declare const UPDATE_CONFIDENTIAL_TRANSFER_MINT_DISCRIMINATOR = 27;
export declare function getUpdateConfidentialTransferMintDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export declare const UPDATE_CONFIDENTIAL_TRANSFER_MINT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR = 1;
export declare function getUpdateConfidentialTransferMintConfidentialTransferDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type UpdateConfidentialTransferMintInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountMint extends string | IAccountMeta<string> = string, TAccountAuthority extends string | IAccountMeta<string> = string, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountMint extends string ? WritableAccount<TAccountMint> : TAccountMint,
    TAccountAuthority extends string ? ReadonlySignerAccount<TAccountAuthority> & IAccountSignerMeta<TAccountAuthority> : TAccountAuthority,
    ...TRemainingAccounts
]>;
export type UpdateConfidentialTransferMintInstructionData = {
    discriminator: number;
    confidentialTransferDiscriminator: number;
    /**
     * Determines if newly configured accounts must be approved by the
     * `authority` before they may be used by the user.
     */
    autoApproveNewAccounts: boolean;
    /** New authority to decode any transfer amount in a confidential transfer. */
    auditorElgamalPubkey: Option<Address>;
};
export type UpdateConfidentialTransferMintInstructionDataArgs = {
    /**
     * Determines if newly configured accounts must be approved by the
     * `authority` before they may be used by the user.
     */
    autoApproveNewAccounts: boolean;
    /** New authority to decode any transfer amount in a confidential transfer. */
    auditorElgamalPubkey: OptionOrNullable<Address>;
};
export declare function getUpdateConfidentialTransferMintInstructionDataEncoder(): Encoder<UpdateConfidentialTransferMintInstructionDataArgs>;
export declare function getUpdateConfidentialTransferMintInstructionDataDecoder(): Decoder<UpdateConfidentialTransferMintInstructionData>;
export declare function getUpdateConfidentialTransferMintInstructionDataCodec(): Codec<UpdateConfidentialTransferMintInstructionDataArgs, UpdateConfidentialTransferMintInstructionData>;
export type UpdateConfidentialTransferMintInput<TAccountMint extends string = string, TAccountAuthority extends string = string> = {
    /** The SPL Token mint. */
    mint: Address<TAccountMint>;
    /** Confidential transfer mint authority. */
    authority: TransactionSigner<TAccountAuthority>;
    autoApproveNewAccounts: UpdateConfidentialTransferMintInstructionDataArgs['autoApproveNewAccounts'];
    auditorElgamalPubkey: UpdateConfidentialTransferMintInstructionDataArgs['auditorElgamalPubkey'];
};
export declare function getUpdateConfidentialTransferMintInstruction<TAccountMint extends string, TAccountAuthority extends string, TProgramAddress extends Address = typeof TOKEN_2022_PROGRAM_ADDRESS>(input: UpdateConfidentialTransferMintInput<TAccountMint, TAccountAuthority>, config?: {
    programAddress?: TProgramAddress;
}): UpdateConfidentialTransferMintInstruction<TProgramAddress, TAccountMint, TAccountAuthority>;
export type ParsedUpdateConfidentialTransferMintInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** The SPL Token mint. */
        mint: TAccountMetas[0];
        /** Confidential transfer mint authority. */
        authority: TAccountMetas[1];
    };
    data: UpdateConfidentialTransferMintInstructionData;
};
export declare function parseUpdateConfidentialTransferMintInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedUpdateConfidentialTransferMintInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=updateConfidentialTransferMint.d.ts.map