/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type ReadonlyAccount, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount } from '@solana/kit';
import { TOKEN_2022_PROGRAM_ADDRESS } from '../programs';
import { type DecryptableBalance, type DecryptableBalanceArgs } from '../types';
export declare const CONFIDENTIAL_WITHDRAW_DISCRIMINATOR = 27;
export declare function getConfidentialWithdrawDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export declare const CONFIDENTIAL_WITHDRAW_CONFIDENTIAL_TRANSFER_DISCRIMINATOR = 6;
export declare function getConfidentialWithdrawConfidentialTransferDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type ConfidentialWithdrawInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountToken extends string | IAccountMeta<string> = string, TAccountMint extends string | IAccountMeta<string> = string, TAccountInstructionsSysvar extends string | IAccountMeta<string> = string, TAccountEqualityRecord extends string | IAccountMeta<string> = string, TAccountRangeRecord extends string | IAccountMeta<string> = string, TAccountAuthority extends string | IAccountMeta<string> = string, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountToken extends string ? WritableAccount<TAccountToken> : TAccountToken,
    TAccountMint extends string ? ReadonlyAccount<TAccountMint> : TAccountMint,
    TAccountInstructionsSysvar extends string ? ReadonlyAccount<TAccountInstructionsSysvar> : TAccountInstructionsSysvar,
    TAccountEqualityRecord extends string ? ReadonlyAccount<TAccountEqualityRecord> : TAccountEqualityRecord,
    TAccountRangeRecord extends string ? ReadonlyAccount<TAccountRangeRecord> : TAccountRangeRecord,
    TAccountAuthority extends string ? ReadonlyAccount<TAccountAuthority> : TAccountAuthority,
    ...TRemainingAccounts
]>;
export type ConfidentialWithdrawInstructionData = {
    discriminator: number;
    confidentialTransferDiscriminator: number;
    /** The amount of tokens to withdraw. */
    amount: bigint;
    /** Expected number of base 10 digits to the right of the decimal place. */
    decimals: number;
    /** The new decryptable balance if the withdrawal succeeds. */
    newDecryptableAvailableBalance: DecryptableBalance;
    /**
     * Relative location of the
     * `ProofInstruction::VerifyCiphertextCommitmentEquality` instruction
     * to the `Withdraw` instruction in the transaction. If the offset is
     * `0`, then use a context state account for the proof.
     */
    equalityProofInstructionOffset: number;
    /**
     * Relative location of the `ProofInstruction::BatchedRangeProofU64`
     * instruction to the `Withdraw` instruction in the transaction. If the
     * offset is `0`, then use a context state account for the proof.
     */
    rangeProofInstructionOffset: number;
};
export type ConfidentialWithdrawInstructionDataArgs = {
    /** The amount of tokens to withdraw. */
    amount: number | bigint;
    /** Expected number of base 10 digits to the right of the decimal place. */
    decimals: number;
    /** The new decryptable balance if the withdrawal succeeds. */
    newDecryptableAvailableBalance: DecryptableBalanceArgs;
    /**
     * Relative location of the
     * `ProofInstruction::VerifyCiphertextCommitmentEquality` instruction
     * to the `Withdraw` instruction in the transaction. If the offset is
     * `0`, then use a context state account for the proof.
     */
    equalityProofInstructionOffset: number;
    /**
     * Relative location of the `ProofInstruction::BatchedRangeProofU64`
     * instruction to the `Withdraw` instruction in the transaction. If the
     * offset is `0`, then use a context state account for the proof.
     */
    rangeProofInstructionOffset: number;
};
export declare function getConfidentialWithdrawInstructionDataEncoder(): Encoder<ConfidentialWithdrawInstructionDataArgs>;
export declare function getConfidentialWithdrawInstructionDataDecoder(): Decoder<ConfidentialWithdrawInstructionData>;
export declare function getConfidentialWithdrawInstructionDataCodec(): Codec<ConfidentialWithdrawInstructionDataArgs, ConfidentialWithdrawInstructionData>;
export type ConfidentialWithdrawInput<TAccountToken extends string = string, TAccountMint extends string = string, TAccountInstructionsSysvar extends string = string, TAccountEqualityRecord extends string = string, TAccountRangeRecord extends string = string, TAccountAuthority extends string = string> = {
    /** The SPL Token account. */
    token: Address<TAccountToken>;
    /** The corresponding SPL Token mint. */
    mint: Address<TAccountMint>;
    /**
     * Instructions sysvar if at least one of the
     * `zk_elgamal_proof` instructions are included in the same
     * transaction.
     */
    instructionsSysvar?: Address<TAccountInstructionsSysvar>;
    /** (Optional) Equality proof record account or context state account. */
    equalityRecord?: Address<TAccountEqualityRecord>;
    /** (Optional) Range proof record account or context state account. */
    rangeRecord?: Address<TAccountRangeRecord>;
    /** The source account's owner/delegate or its multisignature account. */
    authority: Address<TAccountAuthority> | TransactionSigner<TAccountAuthority>;
    amount: ConfidentialWithdrawInstructionDataArgs['amount'];
    decimals: ConfidentialWithdrawInstructionDataArgs['decimals'];
    newDecryptableAvailableBalance: ConfidentialWithdrawInstructionDataArgs['newDecryptableAvailableBalance'];
    equalityProofInstructionOffset: ConfidentialWithdrawInstructionDataArgs['equalityProofInstructionOffset'];
    rangeProofInstructionOffset: ConfidentialWithdrawInstructionDataArgs['rangeProofInstructionOffset'];
    multiSigners?: Array<TransactionSigner>;
};
export declare function getConfidentialWithdrawInstruction<TAccountToken extends string, TAccountMint extends string, TAccountInstructionsSysvar extends string, TAccountEqualityRecord extends string, TAccountRangeRecord extends string, TAccountAuthority extends string, TProgramAddress extends Address = typeof TOKEN_2022_PROGRAM_ADDRESS>(input: ConfidentialWithdrawInput<TAccountToken, TAccountMint, TAccountInstructionsSysvar, TAccountEqualityRecord, TAccountRangeRecord, TAccountAuthority>, config?: {
    programAddress?: TProgramAddress;
}): ConfidentialWithdrawInstruction<TProgramAddress, TAccountToken, TAccountMint, TAccountInstructionsSysvar, TAccountEqualityRecord, TAccountRangeRecord, (typeof input)['authority'] extends TransactionSigner<TAccountAuthority> ? ReadonlySignerAccount<TAccountAuthority> & IAccountSignerMeta<TAccountAuthority> : TAccountAuthority>;
export type ParsedConfidentialWithdrawInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** The SPL Token account. */
        token: TAccountMetas[0];
        /** The corresponding SPL Token mint. */
        mint: TAccountMetas[1];
        /**
         * Instructions sysvar if at least one of the
         * `zk_elgamal_proof` instructions are included in the same
         * transaction.
         */
        instructionsSysvar?: TAccountMetas[2] | undefined;
        /** (Optional) Equality proof record account or context state account. */
        equalityRecord?: TAccountMetas[3] | undefined;
        /** (Optional) Range proof record account or context state account. */
        rangeRecord?: TAccountMetas[4] | undefined;
        /** The source account's owner/delegate or its multisignature account. */
        authority: TAccountMetas[5];
    };
    data: ConfidentialWithdrawInstructionData;
};
export declare function parseConfidentialWithdrawInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedConfidentialWithdrawInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=confidentialWithdraw.d.ts.map