/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type ReadonlyAccount, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount } from '@solana/kit';
import { TOKEN_2022_PROGRAM_ADDRESS } from '../programs';
export declare const BURN_DISCRIMINATOR = 8;
export declare function getBurnDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type BurnInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountAccount extends string | IAccountMeta<string> = string, TAccountMint extends string | IAccountMeta<string> = string, TAccountAuthority extends string | IAccountMeta<string> = string, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountAccount extends string ? WritableAccount<TAccountAccount> : TAccountAccount,
    TAccountMint extends string ? WritableAccount<TAccountMint> : TAccountMint,
    TAccountAuthority extends string ? ReadonlyAccount<TAccountAuthority> : TAccountAuthority,
    ...TRemainingAccounts
]>;
export type BurnInstructionData = {
    /** The amount of tokens to burn. */
    discriminator: number;
    amount: bigint;
};
export type BurnInstructionDataArgs = {
    amount: number | bigint;
};
export declare function getBurnInstructionDataEncoder(): Encoder<BurnInstructionDataArgs>;
export declare function getBurnInstructionDataDecoder(): Decoder<BurnInstructionData>;
export declare function getBurnInstructionDataCodec(): Codec<BurnInstructionDataArgs, BurnInstructionData>;
export type BurnInput<TAccountAccount extends string = string, TAccountMint extends string = string, TAccountAuthority extends string = string> = {
    /** The account to burn from. */
    account: Address<TAccountAccount>;
    /** The token mint. */
    mint: Address<TAccountMint>;
    /** The account's owner/delegate or its multisignature account. */
    authority: Address<TAccountAuthority> | TransactionSigner<TAccountAuthority>;
    amount: BurnInstructionDataArgs['amount'];
    multiSigners?: Array<TransactionSigner>;
};
export declare function getBurnInstruction<TAccountAccount extends string, TAccountMint extends string, TAccountAuthority extends string, TProgramAddress extends Address = typeof TOKEN_2022_PROGRAM_ADDRESS>(input: BurnInput<TAccountAccount, TAccountMint, TAccountAuthority>, config?: {
    programAddress?: TProgramAddress;
}): BurnInstruction<TProgramAddress, TAccountAccount, TAccountMint, (typeof input)['authority'] extends TransactionSigner<TAccountAuthority> ? ReadonlySignerAccount<TAccountAuthority> & IAccountSignerMeta<TAccountAuthority> : TAccountAuthority>;
export type ParsedBurnInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** The account to burn from. */
        account: TAccountMetas[0];
        /** The token mint. */
        mint: TAccountMetas[1];
        /** The account's owner/delegate or its multisignature account. */
        authority: TAccountMetas[2];
    };
    data: BurnInstructionData;
};
export declare function parseBurnInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedBurnInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=burn.d.ts.map