/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type ReadonlyAccount, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount } from '@solana/kit';
import { STAKE_PROGRAM_ADDRESS } from '../programs';
import { type StakeAuthorize, type StakeAuthorizeArgs } from '../types';
export declare const AUTHORIZE_WITH_SEED_DISCRIMINATOR = 8;
export declare function getAuthorizeWithSeedDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type AuthorizeWithSeedInstruction<TProgram extends string = typeof STAKE_PROGRAM_ADDRESS, TAccountStake extends string | IAccountMeta<string> = string, TAccountBase extends string | IAccountMeta<string> = string, TAccountClockSysvar extends string | IAccountMeta<string> = 'SysvarC1ock11111111111111111111111111111111', TAccountLockupAuthority extends string | IAccountMeta<string> | undefined = undefined, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountStake extends string ? WritableAccount<TAccountStake> : TAccountStake,
    TAccountBase extends string ? ReadonlySignerAccount<TAccountBase> & IAccountSignerMeta<TAccountBase> : TAccountBase,
    TAccountClockSysvar extends string ? ReadonlyAccount<TAccountClockSysvar> : TAccountClockSysvar,
    ...(TAccountLockupAuthority extends undefined ? [] : [
        TAccountLockupAuthority extends string ? ReadonlySignerAccount<TAccountLockupAuthority> & IAccountSignerMeta<TAccountLockupAuthority> : TAccountLockupAuthority
    ]),
    ...TRemainingAccounts
]>;
export type AuthorizeWithSeedInstructionData = {
    discriminator: number;
    newAuthorizedPubkey: Address;
    stakeAuthorize: StakeAuthorize;
    authoritySeed: string;
    authorityOwner: Address;
};
export type AuthorizeWithSeedInstructionDataArgs = {
    newAuthorizedPubkey: Address;
    stakeAuthorize: StakeAuthorizeArgs;
    authoritySeed: string;
    authorityOwner: Address;
};
export declare function getAuthorizeWithSeedInstructionDataEncoder(): Encoder<AuthorizeWithSeedInstructionDataArgs>;
export declare function getAuthorizeWithSeedInstructionDataDecoder(): Decoder<AuthorizeWithSeedInstructionData>;
export declare function getAuthorizeWithSeedInstructionDataCodec(): Codec<AuthorizeWithSeedInstructionDataArgs, AuthorizeWithSeedInstructionData>;
export type AuthorizeWithSeedInput<TAccountStake extends string = string, TAccountBase extends string = string, TAccountClockSysvar extends string = string, TAccountLockupAuthority extends string = string> = {
    /** Stake account to be updated */
    stake: Address<TAccountStake>;
    /** Base key of stake or withdraw authority */
    base: TransactionSigner<TAccountBase>;
    /** Clock sysvar */
    clockSysvar?: Address<TAccountClockSysvar>;
    /** Lockup authority */
    lockupAuthority?: TransactionSigner<TAccountLockupAuthority>;
    newAuthorizedPubkey: AuthorizeWithSeedInstructionDataArgs['newAuthorizedPubkey'];
    stakeAuthorize: AuthorizeWithSeedInstructionDataArgs['stakeAuthorize'];
    authoritySeed: AuthorizeWithSeedInstructionDataArgs['authoritySeed'];
    authorityOwner: AuthorizeWithSeedInstructionDataArgs['authorityOwner'];
};
export declare function getAuthorizeWithSeedInstruction<TAccountStake extends string, TAccountBase extends string, TAccountClockSysvar extends string, TAccountLockupAuthority extends string, TProgramAddress extends Address = typeof STAKE_PROGRAM_ADDRESS>(input: AuthorizeWithSeedInput<TAccountStake, TAccountBase, TAccountClockSysvar, TAccountLockupAuthority>, config?: {
    programAddress?: TProgramAddress;
}): AuthorizeWithSeedInstruction<TProgramAddress, TAccountStake, TAccountBase, TAccountClockSysvar, TAccountLockupAuthority>;
export type ParsedAuthorizeWithSeedInstruction<TProgram extends string = typeof STAKE_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** Stake account to be updated */
        stake: TAccountMetas[0];
        /** Base key of stake or withdraw authority */
        base: TAccountMetas[1];
        /** Clock sysvar */
        clockSysvar: TAccountMetas[2];
        /** Lockup authority */
        lockupAuthority?: TAccountMetas[3] | undefined;
    };
    data: AuthorizeWithSeedInstructionData;
};
export declare function parseAuthorizeWithSeedInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedAuthorizeWithSeedInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=authorizeWithSeed.d.ts.map