/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type ReadonlyAccount, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount } from '@solana/kit';
import { STAKE_PROGRAM_ADDRESS } from '../programs';
import { type StakeAuthorize, type StakeAuthorizeArgs } from '../types';
export declare const AUTHORIZE_DISCRIMINATOR = 1;
export declare function getAuthorizeDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type AuthorizeInstruction<TProgram extends string = typeof STAKE_PROGRAM_ADDRESS, TAccountStake extends string | IAccountMeta<string> = string, TAccountClockSysvar extends string | IAccountMeta<string> = 'SysvarC1ock11111111111111111111111111111111', TAccountAuthority extends string | IAccountMeta<string> = string, TAccountLockupAuthority extends string | IAccountMeta<string> | undefined = undefined, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountStake extends string ? WritableAccount<TAccountStake> : TAccountStake,
    TAccountClockSysvar extends string ? ReadonlyAccount<TAccountClockSysvar> : TAccountClockSysvar,
    TAccountAuthority extends string ? ReadonlySignerAccount<TAccountAuthority> & IAccountSignerMeta<TAccountAuthority> : TAccountAuthority,
    ...(TAccountLockupAuthority extends undefined ? [] : [
        TAccountLockupAuthority extends string ? ReadonlySignerAccount<TAccountLockupAuthority> & IAccountSignerMeta<TAccountLockupAuthority> : TAccountLockupAuthority
    ]),
    ...TRemainingAccounts
]>;
export type AuthorizeInstructionData = {
    discriminator: number;
    arg0: Address;
    arg1: StakeAuthorize;
};
export type AuthorizeInstructionDataArgs = {
    arg0: Address;
    arg1: StakeAuthorizeArgs;
};
export declare function getAuthorizeInstructionDataEncoder(): Encoder<AuthorizeInstructionDataArgs>;
export declare function getAuthorizeInstructionDataDecoder(): Decoder<AuthorizeInstructionData>;
export declare function getAuthorizeInstructionDataCodec(): Codec<AuthorizeInstructionDataArgs, AuthorizeInstructionData>;
export type AuthorizeInput<TAccountStake extends string = string, TAccountClockSysvar extends string = string, TAccountAuthority extends string = string, TAccountLockupAuthority extends string = string> = {
    /** Stake account to be updated */
    stake: Address<TAccountStake>;
    /** Clock sysvar */
    clockSysvar?: Address<TAccountClockSysvar>;
    /** Stake or withdraw authority */
    authority: TransactionSigner<TAccountAuthority>;
    /** Lockup authority */
    lockupAuthority?: TransactionSigner<TAccountLockupAuthority>;
    arg0: AuthorizeInstructionDataArgs['arg0'];
    arg1: AuthorizeInstructionDataArgs['arg1'];
};
export declare function getAuthorizeInstruction<TAccountStake extends string, TAccountClockSysvar extends string, TAccountAuthority extends string, TAccountLockupAuthority extends string, TProgramAddress extends Address = typeof STAKE_PROGRAM_ADDRESS>(input: AuthorizeInput<TAccountStake, TAccountClockSysvar, TAccountAuthority, TAccountLockupAuthority>, config?: {
    programAddress?: TProgramAddress;
}): AuthorizeInstruction<TProgramAddress, TAccountStake, TAccountClockSysvar, TAccountAuthority, TAccountLockupAuthority>;
export type ParsedAuthorizeInstruction<TProgram extends string = typeof STAKE_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** Stake account to be updated */
        stake: TAccountMetas[0];
        /** Clock sysvar */
        clockSysvar: TAccountMetas[1];
        /** Stake or withdraw authority */
        authority: TAccountMetas[2];
        /** Lockup authority */
        lockupAuthority?: TAccountMetas[3] | undefined;
    };
    data: AuthorizeInstructionData;
};
export declare function parseAuthorizeInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedAuthorizeInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=authorize.d.ts.map