"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
function _path() {
  const data = _interopRequireDefault(require("path"));
  _path = function () {
    return data;
  };
  return data;
}
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

function findXcodeProject(files) {
  const sortedFiles = files.sort();
  for (let i = sortedFiles.length - 1; i >= 0; i--) {
    const fileName = files[i];
    const ext = _path().default.extname(fileName);
    const projectPath = _path().default.dirname(fileName);
    if (ext === '.xcworkspace') {
      return {
        name: fileName,
        path: projectPath,
        isWorkspace: true
      };
    }
    if (ext === '.xcodeproj') {
      return {
        name: fileName,
        path: projectPath,
        isWorkspace: false
      };
    }
  }
  return null;
}
var _default = findXcodeProject;
exports.default = _default;

//# sourceMappingURL=/Users/thymikee/Developer/rnccli/packages/cli-config-apple/build/config/findXcodeProject.js.map