import { BleManager as RNBleManager, Device, BleError } from "react-native-ble-plx";
export declare class BlePlxManager {
    /**
     * Returns the instance of the Bluetooth Low Energy Manager. It initializes it only
     * when it's first needed, preventing the permission prompt happening prematurely.
     * Important: Do NOT access the _bleManager variable directly.
     * Use this function instead.
     * @returns {BleManager} - The instance of the BleManager.
     */
    static _instance: RNBleManager;
    static get instance(): RNBleManager;
    static waitOn(): Promise<void>;
    static getKnownDevice(identifier: string): Promise<Device>;
    static getConnectedDevices(): Promise<Device[]>;
    static connect(identifier: string, options?: Record<string, unknown>): Promise<Device>;
    /**
     * Exposed method from the ble-plx library
     * Sets new log level for native module's logging mechanism.
     * @param logLevel
     */
    static setLogLevel(logLevel: string): Promise<void>;
    static onStateChange(listener: (state: any) => void, emitCurrentState?: boolean): import("react-native-ble-plx").Subscription;
    static startScan(callback: (error: BleError | null, device: Device | null) => void): Promise<void>;
    static stopScan(): Promise<void>;
    static disconnectDevice(deviceIdentifier: string): Promise<void>;
    static cancelTransaction(transactionId: string): Promise<void>;
}
//# sourceMappingURL=BlePlxManager.d.ts.map