import { openTransportReplayer, RecordStore } from "@ledgerhq/hw-transport-mocker";
import Btc from "../src/Btc";

test("transaction on btc – nano s 1.3.1 – native segwit", async () => {
  const transport = await openTransportReplayer(
    RecordStore.fromString(`
    => b001000000
    <= 0107426974636f696e06312e332e323301029000
    => b001000000
    <= 6d00
    => e04000001505800000548000000080000000000000010000001b
    <= 41042e00ef5ab04c270bf697e817c5fd433aa4509b063745d6f82c2157a59d59c1b7146956cee1b5ce1c7739a87fb59de3ad918872b14301af3f00b538934837b1382231354a707a787578426b6358384576465a6e6d4d736a74664771314d676e6d465356b9b92151a60d39e94e5be7a91003d0f43f03cafd69db00ebc60a65434d83e66d9000
    => e0440002050100000001
    <= 9000
    => e04480022e02fc4fd606567a2146ec33fd3904d978167d8309b510071b276734768397aa4eee01000000ef8b01000000000000
    <= 9000
    => e044800204ffffffff
    <= 9000
    => e04aff001505800000548000000080000000000000010000001c
    <= 9000
    => e04a00003202a086010000000000160014562b254f8890788f45c7cf7bd4c81bce789ffcd0bd0400000000000016001483efa2f7154106
    <= 009000
    => e04a80000d6369afcfc98b829886b6c76bf5
    <= 00009000
    => e0440080050100000001
    <= 9000
    => e04480802e02fc4fd606567a2146ec33fd3904d978167d8309b510071b276734768397aa4eee01000000ef8b01000000000019
    <= 9000
    => e04480801d76a9142f3fa4710983519e4ae45dd80e72e70b79f25c5e88acffffffff
    <= 9000
    => e04800001b05800000548000000080000000000000010000001b000000000001
    <= 3045022100e4acf0eb3803a62399f53825d86aa30743fe999eefb01522d5f7ecd9eeec663d022063b90c512e207c2ac47d8759e1c73c6abeff58daec31c48905193470bc87f2d3019000
        `),
  );
  const btc = new Btc({ transport, currency: "zcash" });
  const tx1 = btc.splitTransaction(
    "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",
    true,
    false,
    ["zencash"],
  );
  expect(tx1.outputs?.length).toEqual(40); // 40 outputs in the above transaction. refer to https://explorer.zen-solutions.io/tx/1af7f8e4c77b35f558ee11defe7590c30e85723c0d846787729ecd4fbd45a533
});
