/**
 * @file bip32.ts
 * @description BIP32 Path Handling for Bitcoin Wallets
 *
 * This file provides utility functions to handle BIP32 paths,
 * which are commonly used in hierarchical deterministic (HD) wallets.
 * It includes functions to convert BIP32 paths to and from different formats,
 * extract components from extended public keys (xpubs), and manipulate path elements.
 */
/// <reference types="node" />
/// <reference types="node" />
export declare function pathElementsToBuffer(paths: number[]): Buffer;
export declare function bip32asBuffer(path: string): Buffer;
export declare function pathArrayToString(pathElements: number[]): string;
export declare function pathStringToArray(path: string): number[];
export declare function pubkeyFromXpub(xpub: string): Buffer;
export declare function getXpubComponents(xpub: string): {
    chaincode: Buffer;
    pubkey: Buffer;
    version: number;
};
export declare function hardenedPathOf(pathElements: number[]): number[];
//# sourceMappingURL=bip32.d.ts.map