import { RLP } from '@ethereumjs/rlp';
import { BIGINT_0, BIGINT_1, EthereumJSErrorWithoutCode, concatBytes } from '@ethereumjs/util';
import { keccak256 } from 'ethereum-cryptography/keccak.js';
import { txTypeBytes } from "../util/internal.js";
import { errorMsg } from "./legacy.js";
export function getHashedMessageToSign(tx) {
    const keccakFunction = tx.common.customCrypto.keccak256 ?? keccak256;
    return keccakFunction(tx.getMessageToSign());
}
export function serialize(tx, base) {
    return concatBytes(txTypeBytes(tx.type), RLP.encode(base ?? tx.raw()));
}
export function validateYParity(tx) {
    const { v } = tx;
    if (v !== undefined && v !== BIGINT_0 && v !== BIGINT_1) {
        const msg = errorMsg(tx, 'The y-parity of the transaction should either be 0 or 1');
        throw EthereumJSErrorWithoutCode(msg);
    }
}
//# sourceMappingURL=eip2718.js.map