<img src="https://user-images.githubusercontent.com/4631227/191834116-59cf590e-25cc-4956-ae5c-812ea464f324.png" height="100" />

[GitHub](https://github.com/LedgerHQ/ledger-live/),
[Ledger Devs Discord](https://developers.ledger.com/discord-pro),
[Developer Portal](https://developers.ledger.com/)

## @ledgerhq/hw-transport

`@ledgerhq/hw-transport` implements the generic interface of a Ledger Hardware Wallet transport.

## API

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

#### Table of Contents

*   [Subscription](#subscription)
    *   [Properties](#properties)
*   [Device](#device)
*   [DescriptorEvent](#descriptorevent)
*   [Observer](#observer)
*   [Transport](#transport)
    *   [Parameters](#parameters)
    *   [exchange](#exchange)
        *   [Parameters](#parameters-1)
    *   [exchangeBulk](#exchangebulk)
        *   [Parameters](#parameters-2)
    *   [setScrambleKey](#setscramblekey)
        *   [Parameters](#parameters-3)
    *   [close](#close)
    *   [on](#on)
        *   [Parameters](#parameters-4)
    *   [off](#off)
        *   [Parameters](#parameters-5)
    *   [setDebugMode](#setdebugmode)
    *   [setExchangeTimeout](#setexchangetimeout)
        *   [Parameters](#parameters-6)
    *   [setExchangeUnresponsiveTimeout](#setexchangeunresponsivetimeout)
        *   [Parameters](#parameters-7)
    *   [send](#send)
        *   [Parameters](#parameters-8)
    *   [exchangeAtomicImpl](#exchangeatomicimpl)
        *   [Parameters](#parameters-9)
    *   [setTraceContext](#settracecontext)
        *   [Parameters](#parameters-10)
    *   [updateTraceContext](#updatetracecontext)
        *   [Parameters](#parameters-11)
    *   [getTraceContext](#gettracecontext)
    *   [isSupported](#issupported)
    *   [list](#list)
        *   [Examples](#examples)
    *   [listen](#listen)
        *   [Parameters](#parameters-12)
        *   [Examples](#examples-1)
    *   [open](#open)
        *   [Parameters](#parameters-13)
        *   [Examples](#examples-2)
    *   [create](#create)
        *   [Parameters](#parameters-14)
        *   [Examples](#examples-3)

### Subscription

Type: {unsubscribe: function (): void}

#### Properties

*   `unsubscribe` **function (): void**&#x20;

### Device

Type: any

### DescriptorEvent

A "descriptor" is a parameter that is specific to the implementation, and can be an ID, file path, or URL.
type: add or remove event
descriptor: a parameter that can be passed to open(descriptor)
deviceModel: device info on the model (is it a nano s, nano x, ...)
device: transport specific device info

### Observer

Observer generic type, following the Observer pattern

Type: Readonly<{next: function (event: EventType): any, error: function (e: EventError): any, complete: function (): any}>

### Transport

The Transport class defines a generic interface for communicating with a Ledger hardware wallet.
There are different kind of transports based on the technology (channels like U2F, HID, Bluetooth, Webusb) and environment (Node, Web,...).
It is an abstract class that needs to be implemented.

#### Parameters

*   `$0` **{context: TraceContext?, logType: LogType?}**  (optional, default `{}`)

    *   `$0.context` &#x20;
    *   `$0.logType` &#x20;

#### exchange

Send data to the device using a low level API.
It's recommended to use the "send" method for a higher level API.

##### Parameters

*   `_apdu` **[Buffer](https://nodejs.org/api/buffer.html)**&#x20;
*   `options` **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** Contains optional options for the exchange function*   abortTimeoutMs: stop the exchange after a given timeout. Another timeout exists
        to detect unresponsive device (see `unresponsiveTimeout`). This timeout aborts the exchange. (optional, default `{}`)

    *   `options.abortTimeoutMs` &#x20;
*   `apdu` **[Buffer](https://nodejs.org/api/buffer.html)** The data to send.

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)<[Buffer](https://nodejs.org/api/buffer.html)>** A promise that resolves with the response data from the device.

#### exchangeBulk

Send apdus in batch to the device using a low level API.
The default implementation is to call exchange for each apdu.

##### Parameters

*   `apdus` **[Array](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array)<[Buffer](https://nodejs.org/api/buffer.html)>** array of apdus to send.
*   `observer` **[Observer](#observer)<[Buffer](https://nodejs.org/api/buffer.html)>** an observer that will receive the response of each apdu.

Returns **[Subscription](#subscription)** A Subscription object on which you can call ".unsubscribe()" to stop sending apdus.

#### setScrambleKey

Set the "scramble key" for the next data exchanges with the device.
Each app can have a different scramble key and it is set internally during instantiation.

##### Parameters

*   `_key` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)**&#x20;
*   `key` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** The scramble key to set.
    deprecated This method is no longer needed for modern transports and should be migrated away from.
    no @ before deprecated as it breaks documentationjs on version 14.0.2
    <https://github.com/documentationjs/documentation/issues/1596>

#### close

Close the connection with the device.

Note: for certain transports (hw-transport-node-hid-singleton for ex), once the promise resolved,
the transport instance is actually still cached, and the device is disconnected only after a defined timeout.
But for the consumer of the Transport, this does not matter and it can consider the transport to be closed.

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)\<void>** A promise that resolves when the transport is closed.

#### on

Listen for an event on the transport instance.
Transport implementations may have specific events. Common events include:
"disconnect" : triggered when the transport is disconnected.

##### Parameters

*   `eventName` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** The name of the event to listen for.
*   `cb` **function (...args: [Array](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array)\<any>): any**&#x20;

Returns **void**&#x20;

#### off

Stop listening to an event on an instance of transport.

##### Parameters

*   `eventName` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)**&#x20;
*   `cb` **function (...args: [Array](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array)\<any>): any**&#x20;

Returns **void**&#x20;

#### setDebugMode

Enable or not logs of the binary exchange

#### setExchangeTimeout

Set a timeout (in milliseconds) for the exchange call. Only some transport might implement it. (e.g. U2F)

##### Parameters

*   `exchangeTimeout` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)**&#x20;

Returns **void**&#x20;

#### setExchangeUnresponsiveTimeout

Define the delay before emitting "unresponsive" on an exchange that does not respond

##### Parameters

*   `unresponsiveTimeout` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)**&#x20;

Returns **void**&#x20;

#### send

Send data to the device using the higher level API.

##### Parameters

*   `cla` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** The instruction class for the command.
*   `ins` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** The instruction code for the command.
*   `p1` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** The first parameter for the instruction.
*   `p2` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** The second parameter for the instruction.
*   `data` **[Buffer](https://nodejs.org/api/buffer.html)** The data to be sent. Defaults to an empty buffer. (optional, default `Buffer.alloc(0)`)
*   `statusList` **[Array](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array)<[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)>** A list of acceptable status codes for the response. Defaults to \[StatusCodes.OK]. (optional, default `[StatusCodes.OK]`)
*   `options` **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** Contains optional options for the exchange function*   abortTimeoutMs: stop the send after a given timeout. Another timeout exists
        to detect unresponsive device (see `unresponsiveTimeout`). This timeout aborts the exchange. (optional, default `{}`)

    *   `options.abortTimeoutMs` &#x20;

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)<[Buffer](https://nodejs.org/api/buffer.html)>** A promise that resolves with the response data from the device.

#### exchangeAtomicImpl

Wrapper to make an exchange "atomic" (blocking any other exchange)

It also handles "unresponsiveness" by emitting "unresponsive" and "responsive" events.

##### Parameters

*   `f` **function (): [Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)\<Output>** The exchange job, using the transport to run

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)\<Output>** a Promise resolving with the output of the given job

#### setTraceContext

Sets the context used by the logging/tracing mechanism

Useful when re-using (cached) the same Transport instance,
but with a new tracing context.

##### Parameters

*   `context` **TraceContext?** A TraceContext, that can undefined to reset the context

#### updateTraceContext

Updates the context used by the logging/tracing mechanism

The update only overrides the key-value that are already defined in the current context.

##### Parameters

*   `contextToAdd` **TraceContext** A TraceContext that will be added to the current context

#### getTraceContext

Gets the tracing context of the transport instance

Returns **(TraceContext | [undefined](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/undefined))**&#x20;

#### isSupported

Check if the transport is supported on the current platform/browser.

Type: function (): [Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)<[boolean](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean)>

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)<[boolean](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean)>** A promise that resolves with a boolean indicating support.

#### list

List all available descriptors for the transport.
For a better granularity, checkout `listen()`.

Type: function (): [Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)<[Array](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array)\<any>>

##### Examples

```javascript
TransportFoo.list().then(descriptors => ...)
```

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)<[Array](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array)\<any>>** A promise that resolves with an array of descriptors.

#### listen

Listen for device events for the transport. The method takes an observer of DescriptorEvent and returns a Subscription.
A DescriptorEvent is an object containing a "descriptor" and a "type" field. The "type" field can be "add" or "remove", and the "descriptor" field can be passed to the "open" method.
The "listen" method will first emit all currently connected devices and then will emit events as they occur, such as when a USB device is plugged in or a Bluetooth device becomes discoverable.

Type: function (observer: [Observer](#observer)<[DescriptorEvent](#descriptorevent)\<any>>): [Subscription](#subscription)

##### Parameters

*   `observer` **[Observer](#observer)<[DescriptorEvent](#descriptorevent)\<any>>** An object with "next", "error", and "complete" functions, following the observer pattern.

##### Examples

```javascript
const sub = TransportFoo.listen({
next: e => {
if (e.type==="add") {
sub.unsubscribe();
const transport = await TransportFoo.open(e.descriptor);
...
}
},
error: error => {},
complete: () => {}
})
```

Returns **[Subscription](#subscription)** A Subscription object on which you can call ".unsubscribe()" to stop listening to descriptors.

#### open

Attempt to create a Transport instance with a specific descriptor.

Type: function (descriptor: any, timeoutMs: [number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number), context: TraceContext): [Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)<[Transport](#transport)>

##### Parameters

*   `descriptor` **any** The descriptor to open the transport with.
*   `timeout` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** An optional timeout for the transport connection.
*   `context` **TraceContext** Optional tracing/log context

##### Examples

```javascript
TransportFoo.open(descriptor).then(transport => ...)
```

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)<[Transport](#transport)>** A promise that resolves with a Transport instance.

#### create

create() allows to open the first descriptor available or
throw if there is none or if timeout is reached.
This is a light helper, alternative to using listen() and open() (that you may need for any more advanced usecase)

##### Parameters

*   `openTimeout`   (optional, default `3000`)
*   `listenTimeout` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)?**&#x20;

##### Examples

```javascript
TransportFoo.create().then(transport => ...)
```

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)<[Transport](#transport)>**&#x20;
