<img src="https://user-images.githubusercontent.com/4631227/191834116-59cf590e-25cc-4956-ae5c-812ea464f324.png" height="100" />

[GitHub](https://github.com/LedgerHQ/ledger-live/),
[Ledger Devs Discord](https://developers.ledger.com/discord-pro),
[Developer Portal](https://developers.ledger.com/)

## @ledgerhq/hw-transport-webusb

Allows to communicate with Ledger Hardware Wallets.

**\[Web]** **(WebUSB)** – WebUSB [check browser support](https://caniuse.com/webusb).

***

## Are you adding Ledger support to your software wallet?

You may be using this package to open a USB connection between your web application and the device.

For a smooth and quick integration:

*   See the developers’ documentation on the [Developer Portal](https://developers.ledger.com/docs/transport/overview/) and
*   Go on [Discord](https://developers.ledger.com/discord-pro/) to chat with developer support and the developer community.

***

### FAQ: "DOM Exception" is triggered when creating the transport

The transport functions `create()` and `listen()` must be called in the context of a user interaction (like a **"click"** event), otherwise it fails with DOM Exception. This is by WebUSB design. You also must run on HTTPS.

### How to use this transport regarding WebUSB paradigm?

In WebUSB, we have a "permission native" modal that appears when we need to "request" a device. This is required at-least-once for the user to accept, and then we can open the transport without triggering this modal. However, in both cases, it must happen in context of a click like explain above. Our current implementation trade off is to abstract this out and only trigger the permission modal if no device are listed. This might change in the future.

In terms of UX, there are two classical use cases:

1.  you only need the device at key times, like once to get the address. once to sign a transaction,...
2.  your app lifecycle requires that you need to access the device at the beginning and/or at any time (like you want to ping with getAddress to get the wallet address)

in (1) case, you can just do your logic in each button (Get Address / Sign Transaction) time (create it, do the logic, close it).
in (2) case, you will need to have a Connect button that appear when you don’t have the connection yet. And you need to hook to the “disconnect” event to potentially make the UI reflect that and require user to click again on that Connect button, because you can’t automatically `create()`/`open()` again.

### Support status

WebUSB is currently only supported on Google Chrome / Chromium.

*   In Linux, user need to install the [specific udev rules](https://raw.githubusercontent.com/LedgerHQ/udev-rules/master/add_udev_rules.sh)
*   In Mac, it should work.
*   In Windows, [WebUSB does not work out of the box](https://github.com/WICG/webusb/issues/143) but you can fix it with [Zadig](https://zadig.akeo.ie/).
*   In Android Chrome it works.

## API

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

#### Table of Contents

*   [TransportWebUSB](#transportwebusb)
    *   [Parameters](#parameters)
    *   [Examples](#examples)
    *   [close](#close)
    *   [exchange](#exchange)
        *   [Parameters](#parameters-1)
    *   [isSupported](#issupported)
    *   [list](#list)
    *   [listen](#listen)
        *   [Parameters](#parameters-2)
    *   [request](#request)
    *   [openConnected](#openconnected)
    *   [open](#open)
        *   [Parameters](#parameters-3)

### TransportWebUSB

**Extends Transport**

WebUSB Transport implementation

#### Parameters

*   `device` **USBDevice**&#x20;
*   `interfaceNumber` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)**&#x20;

#### Examples

```javascript
import TransportWebUSB from "@ledgerhq/hw-transport-webusb";
...
TransportWebUSB.create().then(transport => ...)
```

#### close

Release the transport device

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)\<void>**&#x20;

#### exchange

Exchange with the device using APDU protocol.

##### Parameters

*   `apdu` **[Buffer](https://nodejs.org/api/buffer.html)**&#x20;

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)<[Buffer](https://nodejs.org/api/buffer.html)>** a promise of apdu response

#### isSupported

Check if WebUSB transport is supported.

#### list

List the WebUSB devices that was previously authorized by the user.

#### listen

Actively listen to WebUSB devices and emit ONE device
that was either accepted before, if not it will trigger the native permission UI.

Important: it must be called in the context of a UI click!

##### Parameters

*   `observer` **Observer\<DescriptorEvent\<USBDevice>>**&#x20;

Returns **Subscription**&#x20;

#### request

Similar to create() except it will always display the device permission (even if some devices are already accepted).

#### openConnected

Similar to create() except it will never display the device permission (it returns a Promise\<?Transport>, null if it fails to find a device).

#### open

Create a Ledger transport with a USBDevice

##### Parameters

*   `device` **USBDevice**&#x20;
