<img src="https://user-images.githubusercontent.com/4631227/191834116-59cf590e-25cc-4956-ae5c-812ea464f324.png" height="100" />

## @ledgerhq/errors

Hodl all possible errors of Ledger (live, ledgerjs) so we can deal with them in a unified way (share between libraries, `instanceof` them,...)

## API

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

#### Table of Contents

*   [HwTransportErrorType](#hwtransporterrortype)
*   [HwTransportError](#hwtransporterror)
    *   [Parameters](#parameters)
*   [TransportError](#transporterror)
    *   [Parameters](#parameters-1)
*   [TransportStatusError](#transportstatuserror)
    *   [Parameters](#parameters-2)

### HwTransportErrorType

Type of a Transport error used to represent all equivalent errors coming from all possible implementation of Transport

### HwTransportError

**Extends Error**

Represents an error coming from the usage of any Transport implementation.

Needed to map a specific implementation error into an error that
can be managed by any code unaware of the specific Transport implementation
that was used.

#### Parameters

*   `type` **[HwTransportErrorType](#hwtransporterrortype)**&#x20;
*   `message` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)**&#x20;

### TransportError

**Extends Error**

TransportError is used for any generic transport errors.
e.g. Error thrown when data received by exchanges are incorrect or if exchanged failed to communicate with the device for various reason.

#### Parameters

*   `message` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)**&#x20;
*   `id` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)**&#x20;

### TransportStatusError

**Extends Error**

Error thrown when a device returned a non success status.
the error.statusCode is one of the `StatusCodes` exported by this library.

#### Parameters

*   `statusCode` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** The error status code coming from a Transport implementation
*   `options` **{canBeMappedToChildError: [boolean](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean)?}** containing:*   canBeMappedToChildError: enable the mapping of TransportStatusError to an error extending/inheriting from it
        . Ex: LockedDeviceError. Default to true. (optional, default `{}`)

    *   `options.canBeMappedToChildError`   (optional, default `true`)
