import { type EmitterSubscription } from 'react-native';
import type { ErrorListenerCallback, PinningOptions } from './types';
export type * from './types';
/**
 * Checks whether the SslPublicKeyPinning NativeModule is available on the current app installation.
 * Useful if you're using Expo Go and want to avoid initializing pinning if it's not available.
 * @returns true if SslPublicKeyPinning is available
 */
export declare function isSslPinningAvailable(): boolean;
/**
 * Initializes and enables SSL public key pinning for the domains and options you specify.
 * @param options Mapping from domain name to DomainOptions
 * @returns Promise that resolves once initialization is complete
 */
export declare function initializeSslPinning(options: PinningOptions): Promise<void>;
/**
 * Disables SSL public key pinning.
 * @returns Promise that resolves once disabling is complete
 */
export declare function disableSslPinning(): Promise<void>;
export declare function addSslPinningErrorListener(callback: ErrorListenerCallback): EmitterSubscription;
//# sourceMappingURL=index.d.ts.map