"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addSslPinningErrorListener = addSslPinningErrorListener;
exports.disableSslPinning = disableSslPinning;
exports.initializeSslPinning = initializeSslPinning;
exports.isSslPinningAvailable = isSslPinningAvailable;
var _reactNative = require("react-native");
const LINKING_ERROR = `The package 'react-native-ssl-public-key-pinning' doesn't seem to be linked. Make sure: \n\n` + _reactNative.Platform.select({
  ios: "- You have run 'pod install'\n",
  default: ''
}) + '- You rebuilt the app after installing the package\n' + '- You are not using Expo Go\n';

// @ts-expect-error
const isTurboModuleEnabled = global.__turboModuleProxy != null;
const SslPublicKeyPinningModule = isTurboModuleEnabled ? require('./NativeSslPublicKeyPinning').default : _reactNative.NativeModules.SslPublicKeyPinning;
const SslPublicKeyPinning = SslPublicKeyPinningModule ? SslPublicKeyPinningModule : new Proxy({}, {
  get() {
    throw new Error(LINKING_ERROR);
  }
});
const PINNING_ERROR_EVENT_NAME = 'pinning-error';

/**
 * Checks whether the SslPublicKeyPinning NativeModule is available on the current app installation.
 * Useful if you're using Expo Go and want to avoid initializing pinning if it's not available.
 * @returns true if SslPublicKeyPinning is available
 */
function isSslPinningAvailable() {
  return SslPublicKeyPinningModule != null;
}

/**
 * Initializes and enables SSL public key pinning for the domains and options you specify.
 * @param options Mapping from domain name to DomainOptions
 * @returns Promise that resolves once initialization is complete
 */
function initializeSslPinning(options) {
  return SslPublicKeyPinning.initialize(options);
}

/**
 * Disables SSL public key pinning.
 * @returns Promise that resolves once disabling is complete
 */
function disableSslPinning() {
  return SslPublicKeyPinning.disable();
}
let emitter = null;
function addSslPinningErrorListener(callback) {
  if (emitter == null) {
    emitter = new _reactNative.NativeEventEmitter(SslPublicKeyPinningModule);
  }
  return emitter.addListener(PINNING_ERROR_EVENT_NAME, callback);
}
//# sourceMappingURL=index.js.map