import { NativeModules, NativeEventEmitter, Platform } from 'react-native';
import { useEffect } from 'react';
let addListen, RNScreenshotPrevent;
if (Platform.OS !== "web") {
  const {
    RNScreenshotPrevent: RNScreenshotPreventNative
  } = NativeModules;
  RNScreenshotPrevent = {
    ...RNScreenshotPreventNative,
    enableSecureView: function enableSecureView(imagePath = "") {
      RNScreenshotPreventNative.enableSecureView(imagePath);
    }
  };
  const eventEmitter = new NativeEventEmitter(RNScreenshotPrevent);

  /**
   * subscribes to userDidTakeScreenshot event
   * @param {function} callback handler
   * @returns {function} unsubscribe fn
   */
  addListen = fn => {
    if (typeof fn !== 'function') {
      console.error('RNScreenshotPrevent: addListener requires valid callback function');
      return {
        remove: () => {
          console.error("RNScreenshotPrevent: remove not work because addListener requires valid callback function");
        }
      };
    }
    return eventEmitter.addListener("userDidTakeScreenshot", fn);
  };
} else {
  RNScreenshotPrevent = {
    enabled: enabled => {
      console.warn("RNScreenshotPrevent: enabled not work in web. value: " + enabled);
    },
    enableSecureView: (imagePath = "") => {
      console.warn("RNScreenshotPrevent: enableSecureView not work in web." + (!!imagePath ? " send: " + imagePath : ""));
    },
    disableSecureView: () => {
      console.warn("RNScreenshotPrevent: disableSecureView not work in web");
    }
  };
  addListen = fn => {
    if (typeof fn !== 'function') {
      console.error('RNScreenshotPrevent: addListener requires valid callback function');
      return {
        remove: () => {
          console.error("RNScreenshotPrevent: remove not work because addListener requires valid callback function");
        }
      };
    }
    console.warn("RNScreenshotPrevent: addListener not work in web");
    return {
      remove: () => {
        console.warn("RNScreenshotPrevent: remove addListener not work in web");
      }
    };
  };
}
export const usePreventScreenshot = () => {
  useEffect(() => {
    RNScreenshotPrevent.enabled(true);
    return () => {
      RNScreenshotPrevent.enabled(false);
    };
  }, []);
};
export const useDisableSecureView = (imagePath = "") => {
  useEffect(() => {
    RNScreenshotPrevent.enableSecureView(imagePath);
    return () => {
      RNScreenshotPrevent.disableSecureView();
    };
  }, []);
};
export const enabled = RNScreenshotPrevent.enabled;
export const enableSecureView = RNScreenshotPrevent.enableSecureView;
export const disableSecureView = RNScreenshotPrevent.disableSecureView;
export const addListener = addListen;
export default RNScreenshotPrevent;
//# sourceMappingURL=index.js.map