import * as React from "react";
import { Platform, StatusBar as RNStatusBar } from "react-native";
import NativeModule from "./NativeRNBars";
function createStackEntry({
  animated = false,
  barStyle = "light-content"
}) {
  return {
    animated,
    barStyle
  };
}
export class StatusBar extends React.Component {
  static propsStack = [];
  static immediate = null;
  static mergedProps = null;
  static pushStackEntry(props) {
    const entry = createStackEntry(props);
    StatusBar.propsStack.push(entry);
    StatusBar.updatePropsStack();
    return entry;
  }
  static popStackEntry(entry) {
    const index = StatusBar.propsStack.indexOf(entry);
    if (index !== -1) {
      StatusBar.propsStack.splice(index, 1);
    }
    StatusBar.updatePropsStack();
  }
  static replaceStackEntry(entry, props) {
    const newEntry = createStackEntry(props);
    const index = StatusBar.propsStack.indexOf(entry);
    if (index !== -1) {
      StatusBar.propsStack[index] = newEntry;
    }
    StatusBar.updatePropsStack();
    return newEntry;
  }
  static updatePropsStack() {
    // Send the update to the native module only once at the end of the frame.
    if (StatusBar.immediate !== null) {
      clearImmediate(StatusBar.immediate);
    }
    StatusBar.immediate = setImmediate(() => {
      const oldProps = StatusBar.mergedProps;
      const lastEntry = StatusBar.propsStack[StatusBar.propsStack.length - 1];
      if (lastEntry != null) {
        // Update only if style have changed or if current props are unavailable.
        if (oldProps?.barStyle !== lastEntry.barStyle) {
          if (Platform.OS === "android") {
            NativeModule?.setStatusBarStyle(lastEntry.barStyle);
          } else {
            RNStatusBar.setBarStyle(lastEntry.barStyle, lastEntry.animated);
          }
        }

        // Update the current props values.
        StatusBar.mergedProps = {
          ...lastEntry
        };
      } else {
        // Reset current props when the stack is empty.
        StatusBar.mergedProps = null;
      }
    });
  }
  stackEntry = null;
  componentDidMount() {
    this.stackEntry = StatusBar.pushStackEntry(this.props);
  }
  componentDidUpdate() {
    if (this.stackEntry) {
      this.stackEntry = StatusBar.replaceStackEntry(this.stackEntry, this.props);
    }
  }
  componentWillUnmount() {
    if (this.stackEntry) {
      StatusBar.popStackEntry(this.stackEntry);
    }
  }
  render() {
    return null;
  }
}
//# sourceMappingURL=StatusBar.js.map