"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusBar = void 0;
var React = _interopRequireWildcard(require("react"));
var _reactNative = require("react-native");
var _NativeRNBars = _interopRequireDefault(require("./NativeRNBars"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function createStackEntry({
  animated = false,
  barStyle = "light-content"
}) {
  return {
    animated,
    barStyle
  };
}
class StatusBar extends React.Component {
  static propsStack = [];
  static immediate = null;
  static mergedProps = null;
  static pushStackEntry(props) {
    const entry = createStackEntry(props);
    StatusBar.propsStack.push(entry);
    StatusBar.updatePropsStack();
    return entry;
  }
  static popStackEntry(entry) {
    const index = StatusBar.propsStack.indexOf(entry);
    if (index !== -1) {
      StatusBar.propsStack.splice(index, 1);
    }
    StatusBar.updatePropsStack();
  }
  static replaceStackEntry(entry, props) {
    const newEntry = createStackEntry(props);
    const index = StatusBar.propsStack.indexOf(entry);
    if (index !== -1) {
      StatusBar.propsStack[index] = newEntry;
    }
    StatusBar.updatePropsStack();
    return newEntry;
  }
  static updatePropsStack() {
    // Send the update to the native module only once at the end of the frame.
    if (StatusBar.immediate !== null) {
      clearImmediate(StatusBar.immediate);
    }
    StatusBar.immediate = setImmediate(() => {
      const oldProps = StatusBar.mergedProps;
      const lastEntry = StatusBar.propsStack[StatusBar.propsStack.length - 1];
      if (lastEntry != null) {
        // Update only if style have changed or if current props are unavailable.
        if (oldProps?.barStyle !== lastEntry.barStyle) {
          if (_reactNative.Platform.OS === "android") {
            _NativeRNBars.default?.setStatusBarStyle(lastEntry.barStyle);
          } else {
            _reactNative.StatusBar.setBarStyle(lastEntry.barStyle, lastEntry.animated);
          }
        }

        // Update the current props values.
        StatusBar.mergedProps = {
          ...lastEntry
        };
      } else {
        // Reset current props when the stack is empty.
        StatusBar.mergedProps = null;
      }
    });
  }
  stackEntry = null;
  componentDidMount() {
    this.stackEntry = StatusBar.pushStackEntry(this.props);
  }
  componentDidUpdate() {
    if (this.stackEntry) {
      this.stackEntry = StatusBar.replaceStackEntry(this.stackEntry, this.props);
    }
  }
  componentWillUnmount() {
    if (this.stackEntry) {
      StatusBar.popStackEntry(this.stackEntry);
    }
  }
  render() {
    return null;
  }
}
exports.StatusBar = StatusBar;
//# sourceMappingURL=StatusBar.js.map