"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavigationBar = void 0;
var React = _interopRequireWildcard(require("react"));
var _reactNative = require("react-native");
var _NativeRNBars = _interopRequireDefault(require("./NativeRNBars"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isSupportedPlatform = _reactNative.Platform.OS === "android" && _reactNative.Platform.Version >= 27;
function createStackEntry({
  barStyle = "light-content"
}) {
  return {
    barStyle
  };
}
class NavigationBar extends React.Component {
  static propsStack = [];
  static immediate = null;
  static mergedProps = null;
  static pushStackEntry(props) {
    const entry = createStackEntry(props);
    NavigationBar.propsStack.push(entry);
    NavigationBar.updatePropsStack();
    return entry;
  }
  static popStackEntry(entry) {
    const index = NavigationBar.propsStack.indexOf(entry);
    if (index !== -1) {
      NavigationBar.propsStack.splice(index, 1);
    }
    NavigationBar.updatePropsStack();
  }
  static replaceStackEntry(entry, props) {
    const newEntry = createStackEntry(props);
    const index = NavigationBar.propsStack.indexOf(entry);
    if (index !== -1) {
      NavigationBar.propsStack[index] = newEntry;
    }
    NavigationBar.updatePropsStack();
    return newEntry;
  }
  static updatePropsStack() {
    // Send the update to the native module only once at the end of the frame.
    if (NavigationBar.immediate !== null) {
      clearImmediate(NavigationBar.immediate);
    }
    NavigationBar.immediate = setImmediate(() => {
      const oldProps = NavigationBar.mergedProps;
      const lastEntry = NavigationBar.propsStack[NavigationBar.propsStack.length - 1];
      if (lastEntry != null) {
        // Update only if style have changed or if current props are unavailable.
        if (isSupportedPlatform && oldProps?.barStyle !== lastEntry.barStyle) {
          _NativeRNBars.default?.setNavigationBarStyle(lastEntry.barStyle);
        }

        // Update the current props values.
        NavigationBar.mergedProps = {
          ...lastEntry
        };
      } else {
        // Reset current props when the stack is empty.
        NavigationBar.mergedProps = null;
      }
    });
  }
  stackEntry = null;
  componentDidMount() {
    this.stackEntry = NavigationBar.pushStackEntry(this.props);
  }
  componentDidUpdate() {
    if (this.stackEntry) {
      this.stackEntry = NavigationBar.replaceStackEntry(this.stackEntry, this.props);
    }
  }
  componentWillUnmount() {
    if (this.stackEntry) {
      NavigationBar.popStackEntry(this.stackEntry);
    }
  }
  render() {
    return null;
  }
}
exports.NavigationBar = NavigationBar;
//# sourceMappingURL=NavigationBar.js.map