/// <reference types="node" />
/**
 * Converts a `bigint` to a `number` if it non-negative and at most MAX_SAFE_INTEGER; throws `RangeError` otherwise.
 * Used when converting a Bitcoin-style varint to a `number`, since varints could be larger than what the `Number`
 * class can represent without loss of precision.
 *
 * @param n the number to convert
 * @returns `n` as a `number`
 */
export declare function sanitizeBigintToNumber(n: number | bigint): number;
/**
 * Parses a Bitcoin-style variable length integer from a buffer, starting at the given `offset`. Returns a pair
 * containing the parsed `BigInt`, and its length in bytes from the buffer.
 *
 * @param data the `Buffer` from which the variable-length integer is read
 * @param offset a non-negative offset to read from
 * @returns a pair where the first element is the parsed BigInt, and the second element is the length in bytes parsed
 * from the buffer.
 *
 * @throws `RangeError` if offset is negative.
 * @throws `Error` if the buffer's end is reached withut parsing being completed.
 */
export declare function parseVarint(data: Buffer, offset: number): readonly [bigint, number];
export declare function createVarint(value: number | bigint): Buffer;
