"use strict";
/** @format */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.decodelnurl = void 0;
var bech32_1 = __importDefault(require("bech32"));
var safe_buffer_1 = require("safe-buffer");
var findlnurl_1 = require("./findlnurl");
function decodelnurl(lnurl) {
    lnurl = lnurl.trim();
    if (lnurl.toLowerCase().slice(0, 6) === 'lnurl1') {
        return safe_buffer_1.Buffer.from(bech32_1.default.fromWords(bech32_1.default.decode(lnurl, 20000).words)).toString();
    }
    else if (lnurl.slice(0, 9) === 'lnurlc://' ||
        lnurl.slice(0, 9) === 'lnurlw://' ||
        lnurl.slice(0, 9) === 'lnurlp://' ||
        lnurl.slice(0, 10) === 'keyauth://') {
        var _a = lnurl.split('://'), _ = _a[0], post = _a[1];
        var pre = post.match(/\.onion($|\W)/) ? 'http' : 'https';
        return pre + '://' + post;
    }
    else if (lnurl.slice(0, 8) === 'https://') {
        var bech32lnurl = (0, findlnurl_1.findlnurl)(lnurl);
        if (bech32lnurl) {
            return safe_buffer_1.Buffer.from(bech32_1.default.fromWords(bech32_1.default.decode(bech32lnurl, 20000).words)).toString();
        }
        return lnurl;
    }
    throw new Error("invalid url ".concat(lnurl));
}
exports.decodelnurl = decodelnurl;
