"use strict";
/**
 * this module handles the difference between window (browser) and node js for specific functions and libraries.
 * env.js
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getEnvAtob = exports.getEnvBtoa = void 0;
const getEnvBtoa = () => {
    if (typeof window !== 'undefined')
        return window.btoa; // browser
    else
        return nodeBtoa; // node
};
exports.getEnvBtoa = getEnvBtoa;
const getEnvAtob = () => {
    if (typeof window !== 'undefined')
        return window.atob; // browser
    else
        return nodeAtob; // node
};
exports.getEnvAtob = getEnvAtob;
const nodeBtoa = (str) => {
    if (typeof Buffer === 'undefined')
        throw new Error('UnsupportedEnvironment');
    const buffer = Buffer.from(str.toString(), 'binary');
    return buffer.toString('base64');
};
const nodeAtob = (str) => {
    if (typeof Buffer === 'undefined')
        throw new Error('UnsupportedEnvironment');
    return Buffer.from(str, 'base64').toString('binary');
};
//# sourceMappingURL=env.js.map