"use strict";
/**
 * encoder.js
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.stringToArrayBuffer = exports.arrayBufferToString = exports.hexStringToArrayBuffer = exports.arrayBufferToHexString = exports.decodeBase64Url = exports.encodeBase64Url = exports.decodeBase64 = exports.encodeBase64 = void 0;
const env = __importStar(require("./env"));
/**
 * Encode ArrayBuffer or TypedArray To Base64
 * @param data
 * @return {*}
 */
const encodeBase64 = (data) => {
    let str = '';
    if (typeof data === 'string')
        str = data;
    else
        str = (0, exports.arrayBufferToString)(data);
    const btoa = env.getEnvBtoa();
    return btoa(str);
};
exports.encodeBase64 = encodeBase64;
/**
 * Decode Base64 to Uint8Array
 * @param str
 * @return {Uint8Array|string|*}
 */
const decodeBase64 = (str) => {
    const atob = env.getEnvAtob();
    const binary = atob(str);
    const data = (0, exports.stringToArrayBuffer)(binary);
    return getAsciiIfAscii(data);
};
exports.decodeBase64 = decodeBase64;
/**
 * if input data is an ArrayBuffer or TypedArray, it would be returned as Uint8Array
 * @param data
 * @return {Uint8Array}
 */
const sanitizeTypedArrayAndArrayBuffer = (data) => {
    if (data instanceof Uint8Array)
        return data;
    if (ArrayBuffer.isView(data) && typeof data.buffer !== 'undefined') { // TypedArray except Uint8Array
        return new Uint8Array(data.buffer);
    }
    else
        return new Uint8Array(data); // ArrayBuffer
};
/**
 * Check if the given Uint8Array can be expressed in Ascii Text
 * @param data
 * @return {Uint8Array|string|*}
 */
const getAsciiIfAscii = (data) => {
    let flag = true;
    for (let i = 0; i < data.length; i++) {
        if (data[i] > 0x7e || (data[i] < 0x20 && data[i] !== 0x0d && data[i] !== 0x0a)) {
            flag = false;
            break;
        }
    }
    let returnData = null;
    if (flag) {
        returnData = '';
        for (let i = 0; i < data.length; i++)
            returnData += String.fromCharCode(data[i]);
    }
    else
        returnData = data;
    return returnData;
};
/**
 * Encode ArrayBuffer or TypedArray to base64url string
 * @param data
 * @return {string}
 */
const encodeBase64Url = (data) => (0, exports.encodeBase64)(data).replace(/\+/g, '-').replace(/\//g, '_').replace(/=+$/, '');
exports.encodeBase64Url = encodeBase64Url;
/**
 * Decode Base64Url string to Uint8Array
 * @param str
 * @return {Uint8Array}
 */
const decodeBase64Url = (str) => {
    str = str.replace(/-/g, '+').replace(/_/g, '/');
    // str = str + "=".repeat(str.length % 4); // this sometimes causes error...
    return (0, exports.decodeBase64)(str);
};
exports.decodeBase64Url = decodeBase64Url;
/**
 * Encode ArrayBuffer or TypedArray to hex string
 * @param data
 * @return {string}
 */
const arrayBufferToHexString = (data) => {
    const arr = sanitizeTypedArrayAndArrayBuffer(data);
    let hexStr = '';
    for (let i = 0; i < arr.length; i++) {
        let hex = (arr[i] & 0xff).toString(16);
        hex = (hex.length === 1) ? `0${hex}` : hex;
        hexStr += hex;
    }
    return hexStr;
};
exports.arrayBufferToHexString = arrayBufferToHexString;
/**
 * Decode hex string to Uint8Array
 * @param str
 * @return {Uint8Array}
 */
const hexStringToArrayBuffer = (str) => {
    const arr = [];
    const len = str.length;
    for (let i = 0; i < len; i += 2)
        arr.push(parseInt(str.substr(i, 2), 16));
    return new Uint8Array(arr);
};
exports.hexStringToArrayBuffer = hexStringToArrayBuffer;
/**
 * Encode ArrayBuffer or TypedArray to string with code (like output of legacy atob)
 * @param data
 * @return {string}
 */
const arrayBufferToString = (data) => {
    const bytes = sanitizeTypedArrayAndArrayBuffer(data);
    const arr = new Array(bytes.length);
    bytes.forEach((x, i) => { arr[i] = x; });
    return String.fromCharCode.apply(null, arr);
};
exports.arrayBufferToString = arrayBufferToString;
/**
 * Decode string with code (like output of legacy atob) to Uint8Array
 * @param str
 * @return {Uint8Array}
 */
const stringToArrayBuffer = (str) => {
    const bytes = new Uint8Array(str.length);
    return bytes.map((_x, i) => str.charCodeAt(i));
};
exports.stringToArrayBuffer = stringToArrayBuffer;
//# sourceMappingURL=encoder.js.map