"use strict";
/**
 * hmac.js
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.verify = exports.compute = void 0;
var params_1 = __importDefault(require("./params"));
var util = __importStar(require("js-crypto-env"));
var js_crypto_hash_1 = __importDefault(require("js-crypto-hash"));
/**
 * Compute keyed hash value
 * @param {Uint8Array} key - ByteArray of symmetric key.
 * @param {Uint8Array} data - Byte array of message to be hashed.
 * @param {HashTypes} [hash='SHA-256'] - Name of hash algorithm like 'SHA-256'.
 * @return {Promise<Uint8Array>} - Keyed-hash value.
 * @throws {Error} - Throws if UnsupportedEnvironment, i.e., even neither WebCrypto, NodeCrypto nor PureJS is available.
 */
var compute = function (key, data, hash) {
    if (hash === void 0) { hash = 'SHA-256'; }
    return __awaiter(void 0, void 0, void 0, function () {
        var env, msgKeyedHash, errMsg, native, keyObj, f, e_1, e_2;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    env = util.getCrypto();
                    native = true;
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 6, , 7]);
                    if (!(env.name === 'webCrypto' && typeof env.crypto.importKey === 'function' && typeof env.crypto.sign === 'function')) return [3 /*break*/, 4];
                    return [4 /*yield*/, env.crypto.importKey('raw', key, {
                            name: 'HMAC',
                            hash: { name: hash }
                        }, false, ['sign', 'verify'])];
                case 2:
                    keyObj = _a.sent();
                    return [4 /*yield*/, env.crypto.sign({ name: 'HMAC', hash: { name: hash } }, keyObj, data)];
                case 3:
                    msgKeyedHash = _a.sent();
                    return [3 /*break*/, 5];
                case 4:
                    if (env.name === 'nodeCrypto') { // for node
                        f = env.crypto.createHmac(params_1.default.hashes[hash].nodeName, key);
                        msgKeyedHash = f.update(data).digest();
                    }
                    else
                        native = false;
                    _a.label = 5;
                case 5: return [3 /*break*/, 7];
                case 6:
                    e_1 = _a.sent();
                    if (e_1 instanceof Error) {
                        errMsg = e_1.message;
                    }
                    native = false;
                    return [3 /*break*/, 7];
                case 7:
                    if (!!native) return [3 /*break*/, 11];
                    _a.label = 8;
                case 8:
                    _a.trys.push([8, 10, , 11]);
                    return [4 /*yield*/, purejs(key, data, hash)];
                case 9:
                    msgKeyedHash = _a.sent();
                    return [3 /*break*/, 11];
                case 10:
                    e_2 = _a.sent();
                    if (e_2 instanceof Error) {
                        errMsg = "".concat(errMsg, " => ").concat(e_2.message);
                        throw new Error("UnsupportedEnvironments: ".concat(errMsg));
                    }
                    else {
                        throw new Error('UnsupportedEnvironments');
                    }
                    return [3 /*break*/, 11];
                case 11: return [2 /*return*/, new Uint8Array(msgKeyedHash)];
            }
        });
    });
};
exports.compute = compute;
/**
 * PureJS implementation of HMAC algorithm specified in RFC 2104 {@link https://tools.ietf.org/html/rfc2104}.
 * @param {Uint8Array} key - ByteArray of symmetric key.
 * @param {Uint8Array} data - Byte array of message to be hashed.
 * @param {HashTypes} hash - Name of hash algorithm like 'SHA-256'.
 * @return {Promise<Uint8Array>} - Keyed-hash value.
 */
var purejs = function (key, data, hash) { return __awaiter(void 0, void 0, void 0, function () {
    var B, L, K, KxorIpad, KxorOpad, inner, hashedInner, outer;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                B = params_1.default.hashes[hash].blockSize;
                L = params_1.default.hashes[hash].hashSize;
                if (!(key.length > B)) return [3 /*break*/, 2];
                return [4 /*yield*/, js_crypto_hash_1.default.compute(key, hash)];
            case 1:
                key = _a.sent();
                _a.label = 2;
            case 2:
                K = new Uint8Array(B);
                K.set(key);
                KxorIpad = K.map(function (k) { return 0xFF & (0x36 ^ k); });
                KxorOpad = K.map(function (k) { return 0xFF & (0x5c ^ k); });
                inner = new Uint8Array(B + data.length);
                inner.set(KxorIpad);
                inner.set(data, B);
                return [4 /*yield*/, js_crypto_hash_1.default.compute(inner, hash)];
            case 3:
                hashedInner = _a.sent();
                outer = new Uint8Array(B + L);
                outer.set(KxorOpad);
                outer.set(hashedInner, B);
                return [2 /*return*/, js_crypto_hash_1.default.compute(outer, hash)];
        }
    });
}); };
/**
 * Verify keyed-hash value using the key
 * @param {Uint8Array} key - ByteArray of symmetric key.
 * @param {Uint8Array} data - Byte array of message to be hashed.
 * @param {Uint8Array} mac - Given keyed-hash value.
 * @param {HashTypes} [hash='SHA-256'] - Name of hash algorithm like 'SHA-256'.
 * @return {Promise<boolean>} - Result of verification.
 * @throws {Error} - Throws if InvalidInputMac
 */
var verify = function (key, data, mac, hash) {
    if (hash === void 0) { hash = 'SHA-256'; }
    return __awaiter(void 0, void 0, void 0, function () {
        var newMac;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, (0, exports.compute)(key, data, hash)];
                case 1:
                    newMac = _a.sent();
                    return [2 /*return*/, (mac.toString() === newMac.toString())];
            }
        });
    });
};
exports.verify = verify;
//# sourceMappingURL=hmac.js.map