/**
 * hmac.js
 */
import { HashTypes } from './params';
/**
 * Compute keyed hash value
 * @param {Uint8Array} key - ByteArray of symmetric key.
 * @param {Uint8Array} data - Byte array of message to be hashed.
 * @param {HashTypes} [hash='SHA-256'] - Name of hash algorithm like 'SHA-256'.
 * @return {Promise<Uint8Array>} - Keyed-hash value.
 * @throws {Error} - Throws if UnsupportedEnvironment, i.e., even neither WebCrypto, NodeCrypto nor PureJS is available.
 */
export declare const compute: (key: Uint8Array, data: Uint8Array, hash?: HashTypes) => Promise<Uint8Array>;
/**
 * Verify keyed-hash value using the key
 * @param {Uint8Array} key - ByteArray of symmetric key.
 * @param {Uint8Array} data - Byte array of message to be hashed.
 * @param {Uint8Array} mac - Given keyed-hash value.
 * @param {HashTypes} [hash='SHA-256'] - Name of hash algorithm like 'SHA-256'.
 * @return {Promise<boolean>} - Result of verification.
 * @throws {Error} - Throws if InvalidInputMac
 */
export declare const verify: (key: Uint8Array, data: Uint8Array, mac: Uint8Array, hash?: HashTypes) => Promise<boolean>;
