"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.assertBytes = exports.assertBool = exports.utf8ToBytes = exports.toHex = exports.createView = exports.concatBytes = exports.bytesToHex = void 0;
exports.bytesToUtf8 = bytesToUtf8;
exports.hexToBytes = hexToBytes;
exports.equalsBytes = equalsBytes;
exports.wrapHash = wrapHash;
const utils_1 = require("@noble/curves/abstract/utils");
Object.defineProperty(exports, "assertBool", { enumerable: true, get: function () { return utils_1.abool; } });
const _assert_1 = require("@noble/hashes/_assert");
Object.defineProperty(exports, "assertBytes", { enumerable: true, get: function () { return _assert_1.abytes; } });
const utils_2 = require("@noble/hashes/utils");
var utils_3 = require("@noble/hashes/utils");
Object.defineProperty(exports, "bytesToHex", { enumerable: true, get: function () { return utils_3.bytesToHex; } });
Object.defineProperty(exports, "concatBytes", { enumerable: true, get: function () { return utils_3.concatBytes; } });
Object.defineProperty(exports, "createView", { enumerable: true, get: function () { return utils_3.createView; } });
Object.defineProperty(exports, "toHex", { enumerable: true, get: function () { return utils_3.bytesToHex; } });
Object.defineProperty(exports, "utf8ToBytes", { enumerable: true, get: function () { return utils_3.utf8ToBytes; } });
// buf.toString('utf8') -> bytesToUtf8(buf)
function bytesToUtf8(data) {
    if (!(data instanceof Uint8Array)) {
        throw new TypeError(`bytesToUtf8 expected Uint8Array, got ${typeof data}`);
    }
    return new TextDecoder().decode(data);
}
function hexToBytes(data) {
    const sliced = data.startsWith("0x") ? data.substring(2) : data;
    return (0, utils_2.hexToBytes)(sliced);
}
// buf.equals(buf2) -> equalsBytes(buf, buf2)
function equalsBytes(a, b) {
    if (a.length !== b.length) {
        return false;
    }
    for (let i = 0; i < a.length; i++) {
        if (a[i] !== b[i]) {
            return false;
        }
    }
    return true;
}
// Internal utils
function wrapHash(hash) {
    return (msg) => {
        (0, _assert_1.abytes)(msg);
        return hash(msg);
    };
}
