"use strict";

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var babel = require('@babel/core');

var path = require('path');

var fs = require('fs');

var checkIgnoreDepth = require('../helpers/check-ignore-depth');

var findProjectRoot = require('../helpers/find-project-root');

var getProperties = require('../helpers/get-properties');

var createFixer = require('../helpers/create-fixer');

var isAliasPath = require('../helpers/is-alias-path');

var values = Object.values || function (obj) {
  return Object.keys(obj).map(function (e) {
    return obj[e];
  });
};

var checkPath = function checkPath(path, ext) {
  return fs.existsSync("".concat(path).concat(ext)) || fs.existsSync("".concat(path, "/index").concat(ext));
};

module.exports = {
  meta: {
    docs: {
      description: 'Warn when using relative paths to modules aliased',
      category: 'Fill me in',
      recommended: false
    },
    fixable: 'code',
    schema: [{
      type: 'object',
      properties: {
        ignoreDepth: {
          type: 'integer',
          minimum: 0
        },
        allowDepthMoreOrLessThanEquality: {
          type: 'boolean'
        },
        projectRoot: {
          type: 'string'
        },
        extensions: {
          type: 'array',
          uniqueItems: true,
          items: {
            type: 'string',
            "enum": ['.ts', '.tsx', '.jsx']
          }
        },
        chainedExtensions: {
          type: 'array',
          uniqueItems: true,
          items: {
            type: 'string'
          }
        },
        alias: {
          type: 'object'
        }
      },
      additionalProperties: false
    }]
  },
  create: function create(context) {
    var filename = context.getFilename();
    var filePath = path.dirname(filename); // Plugin options.

    var options = getProperties(context.options);
    var projectRootAbsolutePath = findProjectRoot(filePath, options.projectRoot); // Find alias via babel-plugin-module-resolver config, or use the
    // provided alias map.

    var alias = options.alias;

    if (!alias) {
      alias = {}; // Look for default babel.config file

      var configOptions = babel.loadPartialConfig().options; // No plugins found, look for .babelrc config file

      if (configOptions.plugins.length === 0) {
        configOptions = babel.loadPartialConfig({
          configFile: './.babelrc'
        }).options;
      }

      try {
        var validPluginNames = new Set(['babel-plugin-module-resolver', 'module-resolver']);

        var _configOptions$plugin = configOptions.plugins.filter(function (plugin) {
          if (validPluginNames.has(plugin.file && plugin.file.request)) {
            return plugin;
          }
        }),
            _configOptions$plugin2 = _slicedToArray(_configOptions$plugin, 1),
            moduleResolver = _configOptions$plugin2[0];

        alias = moduleResolver.options.alias || {};
      } catch (error) {
        var message = 'Unable to find config for babel-plugin-module-resolver';
        return {
          ImportDeclaration: function ImportDeclaration(node) {
            context.report({
              node: node,
              message: message,
              loc: node.source.loc
            });
          },
          CallExpression: function CallExpression(node) {
            context.report({
              node: node,
              message: message,
              loc: node.arguments[0].loc
            });
          }
        };
      }
    } // Build array of alias paths.


    var cwd = projectRootAbsolutePath || process.cwd();
    var aliasPaths = values(alias).map(function (a) {
      return path.join(cwd, a);
    });

    var hasError = function hasError(val) {
      if (!val) return false; // template literals will have undefined val

      var ignoreDepth = options.ignoreDepth,
          projectRoot = options.projectRoot,
          extensions = options.extensions,
          allowDepthMoreOrLessThanEquality = options.allowDepthMoreOrLessThanEquality;
      var _options$chainedExten = options.chainedExtensions,
          chainedExtensions = _options$chainedExten === void 0 ? [] : _options$chainedExten; // Be forgiving if the config provides "ext" or ".ext"

      chainedExtensions = chainedExtensions.map(function (ext) {
        return ext.startsWith('.') ? ext : ".".concat(ext);
      }); // Ignore if directory depth matches options.

      if (checkIgnoreDepth({
        ignoreDepth: ignoreDepth,
        path: val,
        allowDepthMoreOrLessThanEquality: allowDepthMoreOrLessThanEquality
      })) return false; // Error if projectRoot option specified but cannot be resolved.

      if (projectRoot && !projectRootAbsolutePath) {
        return {
          suggestFix: false,
          message: 'Invalid project root specified'
        };
      }

      var resolvedPath = path.resolve(filePath, val);
      var pathExt = path.extname(val); // If no extension is present, or if the extension is explicitly
      // allowlisted as chainable, resolve the extension to a `.js` file.

      var resolvedExt = !pathExt || chainedExtensions.includes(pathExt) ? '.js' : '';
      var pathExists = checkPath(resolvedPath, resolvedExt);

      if (extensions && !pathExists) {
        pathExists = extensions.filter(function (ext) {
          return checkPath(resolvedPath, ext);
        }).length;
      }

      var isAliased = aliasPaths.some(function (aliasPath) {
        return isAliasPath(resolvedPath, aliasPath);
      });
      var error = isAliased && pathExists && val.match(/\.\.\//); // matches, exists, and starts with ../,

      return error && {
        suggestFix: true,
        message: 'Do not use relative path for aliased modules'
      };
    };

    var reportError = function reportError(_ref) {
      var node = _ref.node,
          source = _ref.source,
          error = _ref.error;
      context.report({
        node: node,
        message: error.message,
        loc: source.loc,
        fix: error.suggestFix && createFixer({
          alias: alias,
          filePath: filePath,
          cwd: cwd,
          node: node
        })
      });
    };

    return {
      ImportDeclaration: function ImportDeclaration(node) {
        var error = hasError(node.source.value);

        if (error) {
          reportError({
            node: node,
            source: node.source,
            error: error
          });
        }
      },
      CallExpression: function CallExpression(node) {
        var val = node.callee.name || node.callee.type;

        if (val === 'Import' || val === 'require') {
          var error = hasError(node.arguments[0].value);
          error && reportError({
            node: node,
            source: node.arguments[0],
            error: error
          });
        }
      },
      ImportExpression: function ImportExpression(node) {
        // dynamic import was erroneously using visitorKey for
        // call expressions https://github.com/babel/babel/pull/10828
        // adding ImportExpression for new versions of @babel/eslint-parser
        var error = hasError(node.source.value);

        if (error) {
          reportError({
            node: node,
            source: node.source,
            error: error
          });
        }
      }
    };
  }
};