"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.stringToHex = exports.hexToString = exports.randomBytes = exports.hexToBytes = exports.bytesToHex = void 0;
const crypto_1 = require("crypto");
const shared_1 = require("./shared");
const OriginalBuffer = Symbol('OriginalBuffer');
/**
 * Converts a Node.js Buffer to a Uint8Array for uniform behavior with browser implementations.
 *
 * Choices:
 * 1. Directly returning the Buffer:
 *    - Operation: Return Buffer as is (a Buffer *IS* an instanceof Uint8Array).
 *    - Pros: Most memory and performance efficient.
 *    - Cons: Violates strict Uint8Array typing and may lead to issues where Buffer-specific features are [ab]used.
 *
 * 2. Using `new Uint8Array(buffer)` or `Uint8Array.from(buffer)`:
 *    - Operation: Copies the buffer's data into a new Uint8Array.
 *    - Pros: Ensures data isolation; memory-safe.
 *    - Cons: Less performant due to data duplication.
 *
 * 3. Using buf.buffer slice:
 *    - Operation: Shares memory between Buffer and Uint8Array.
 *    - Pros: Performant.
 *    - Cons: Risks with shared memory and potential for invalid references.
 *
 * 4. Using buf.buffer slice and keeping a Buffer reference for ownership semantics:
 *    - Operation: Shares memory and associates the original Buffer with the resulting Uint8Array.
 *    - Pros: Performant while ensuring the original Buffer isn't garbage collected.
 *    - Cons: Risks with shared memory but mitigates potential for invalid references.
 *
 * The chosen method (4) prioritizes performance by sharing memory while ensuring buffer ownership.
 *
 * @param {Buffer} buffer - The Node.js Buffer to convert.
 * @returns {Uint8Array} Resulting Uint8Array sharing the same memory as the Buffer and maintaining a reference to it.
 */
function toUint8Array(buffer) {
    const u8Array = new Uint8Array(buffer.buffer.slice(buffer.byteOffset, buffer.byteOffset + buffer.byteLength));
    u8Array[OriginalBuffer] = buffer;
    return u8Array;
}
/* eslint-disable func-style -- Typed to ensure uniformity between node and browser implementations and docs */
const bytesToHex = (bytes) => {
    const buf = Buffer.from(bytes);
    return buf.toString('hex').toUpperCase();
};
exports.bytesToHex = bytesToHex;
const hexToBytes = (hex) => {
    if (!shared_1.HEX_REGEX.test(hex)) {
        throw new Error('Invalid hex string');
    }
    return toUint8Array(Buffer.from(hex, 'hex'));
};
exports.hexToBytes = hexToBytes;
const randomBytes = (size) => {
    return toUint8Array((0, crypto_1.randomBytes)(size));
};
exports.randomBytes = randomBytes;
const hexToString = (hex, encoding = 'utf8') => {
    if (!shared_1.HEX_REGEX.test(hex)) {
        throw new Error('Invalid hex string');
    }
    return new TextDecoder(encoding).decode((0, exports.hexToBytes)(hex));
};
exports.hexToString = hexToString;
const stringToHex = (string) => {
    return (0, exports.bytesToHex)(new TextEncoder().encode(string));
};
exports.stringToHex = stringToHex;
/* eslint-enable func-style */
__exportStar(require("./shared"), exports);
//# sourceMappingURL=index.js.map