"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const events_1 = require("events");
const client_1 = require("./client");
class WSWrapper extends events_1.EventEmitter {
    _ws;
    static CONNECTING = 0;
    static OPEN = 1;
    static CLOSING = 2;
    static CLOSED = 3;
    constructor(url, _protocols, _websocketOptions) {
        super();
        this._ws = new WebSocket(url, ['wss'], {
            headers: {
                'User-Agent': 'Trezor Suite Native',
            },
        });
        this._ws.onclose = () => {
            this.emit('close');
        };
        this._ws.onopen = () => {
            this.emit('open');
        };
        this._ws.onerror = _event => {
            this.emit('error', new client_1.WebsocketError(`WsWrapper error. Ready state: ${this.readyState}`));
        };
        this._ws.onmessage = message => {
            this.emit('message', message.data);
        };
    }
    close() {
        if (this.readyState === WSWrapper.OPEN) {
            this._ws.close();
        }
    }
    send(message) {
        if (this.readyState !== WSWrapper.OPEN) {
            throw new client_1.WebsocketError(`Connection is not open. state: ${this.readyState}`);
        }
        this._ws.send(message);
    }
    get readyState() {
        return this._ws.readyState;
    }
}
exports.default = WSWrapper;
//# sourceMappingURL=ws-native.js.map