export const urlToOnion = (url, onionDomains) => {
    const [, protocol, subdomain, domain, rest] = url.match(/^(http|ws)s?:\/\/([^:/]+\.)?([^/.]+\.[^/.]+)(\/.*)?$/i) ?? [];
    if (!domain || !onionDomains[domain])
        return;
    return `${protocol}://${subdomain ?? ''}${onionDomains[domain]}${rest ?? ''}`;
};
//# sourceMappingURL=urlToOnion.js.map