export const getLocaleSeparators = (locale) => {
    const numberFormat = new Intl.NumberFormat(locale);
    const parts = numberFormat.formatToParts(10000.1);
    const decimalSeparator = parts.find(({ type }) => type === 'decimal')?.value;
    const thousandsSeparator = parts.find(({ type }) => type === 'group')?.value;
    return { decimalSeparator, thousandsSeparator };
};
//# sourceMappingURL=getLocaleSeparators.js.map