"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.urlToOnion = void 0;
const urlToOnion = (url, onionDomains) => {
    const [, protocol, subdomain, domain, rest] = url.match(/^(http|ws)s?:\/\/([^:/]+\.)?([^/.]+\.[^/.]+)(\/.*)?$/i) ?? [];
    if (!domain || !onionDomains[domain])
        return;
    return `${protocol}://${subdomain ?? ''}${onionDomains[domain]}${rest ?? ''}`;
};
exports.urlToOnion = urlToOnion;
//# sourceMappingURL=urlToOnion.js.map